<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoicesInfoResult StructType
 * @subpackage Structs
 */
class InvoicesInfoResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * The Invoices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvoiceInfoList
     */
    public $Invoices;
    /**
     * Constructor method for InvoicesInfoResult
     * @uses InvoicesInfoResult::setServiceResult()
     * @uses InvoicesInfoResult::setServiceResultDescription()
     * @uses InvoicesInfoResult::setInvoices()
     * @param string $serviceResult
     * @param string $serviceResultDescription
     * @param \ArrayType\ArrayOfInvoiceInfoList $invoices
     */
    public function __construct($serviceResult = null, $serviceResultDescription = null, \ArrayType\ArrayOfInvoiceInfoList $invoices = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setServiceResultDescription($serviceResultDescription)
            ->setInvoices($invoices);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\InvoicesInfoResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\InvoicesInfoResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
    /**
     * Get Invoices value
     * @return \ArrayType\ArrayOfInvoiceInfoList|null
     */
    public function getInvoices()
    {
        return $this->Invoices;
    }
    /**
     * Set Invoices value
     * @param \ArrayType\ArrayOfInvoiceInfoList $invoices
     * @return \StructType\InvoicesInfoResult
     */
    public function setInvoices(\ArrayType\ArrayOfInvoiceInfoList $invoices = null)
    {
        $this->Invoices = $invoices;
        return $this;
    }
}
