<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceInfoList StructType
 * @subpackage Structs
 */
class InvoiceInfoList extends AbstractStructBase
{
    /**
     * The BranchNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchNo;
    /**
     * The BranchName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchName;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvoiceOption
     */
    public $Options;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * Constructor method for InvoiceInfoList
     * @uses InvoiceInfoList::setBranchNo()
     * @uses InvoiceInfoList::setBranchName()
     * @uses InvoiceInfoList::setOptions()
     * @uses InvoiceInfoList::setUUID()
     * @param string $branchNo
     * @param string $branchName
     * @param \ArrayType\ArrayOfInvoiceOption $options
     * @param string $uUID
     */
    public function __construct($branchNo = null, $branchName = null, \ArrayType\ArrayOfInvoiceOption $options = null, $uUID = null)
    {
        $this
            ->setBranchNo($branchNo)
            ->setBranchName($branchName)
            ->setOptions($options)
            ->setUUID($uUID);
    }
    /**
     * Get BranchNo value
     * @return string|null
     */
    public function getBranchNo()
    {
        return $this->BranchNo;
    }
    /**
     * Set BranchNo value
     * @param string $branchNo
     * @return \StructType\InvoiceInfoList
     */
    public function setBranchNo($branchNo = null)
    {
        // validation for constraint: string
        if (!is_null($branchNo) && !is_string($branchNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchNo, true), gettype($branchNo)), __LINE__);
        }
        $this->BranchNo = $branchNo;
        return $this;
    }
    /**
     * Get BranchName value
     * @return string|null
     */
    public function getBranchName()
    {
        return $this->BranchName;
    }
    /**
     * Set BranchName value
     * @param string $branchName
     * @return \StructType\InvoiceInfoList
     */
    public function setBranchName($branchName = null)
    {
        // validation for constraint: string
        if (!is_null($branchName) && !is_string($branchName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchName, true), gettype($branchName)), __LINE__);
        }
        $this->BranchName = $branchName;
        return $this;
    }
    /**
     * Get Options value
     * @return \ArrayType\ArrayOfInvoiceOption|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param \ArrayType\ArrayOfInvoiceOption $options
     * @return \StructType\InvoiceInfoList
     */
    public function setOptions(\ArrayType\ArrayOfInvoiceOption $options = null)
    {
        $this->Options = $options;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\InvoiceInfoList
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
}
