<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceIDRecordResult StructType
 * @subpackage Structs
 */
class InvoiceIDRecordResult extends AbstractStructBase
{
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceId;
    /**
     * The SenderTaxId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderTaxId;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Result;
    /**
     * Constructor method for InvoiceIDRecordResult
     * @uses InvoiceIDRecordResult::setInvoiceId()
     * @uses InvoiceIDRecordResult::setSenderTaxId()
     * @uses InvoiceIDRecordResult::setResult()
     * @param string $invoiceId
     * @param string $senderTaxId
     * @param string $result
     */
    public function __construct($invoiceId = null, $senderTaxId = null, $result = null)
    {
        $this
            ->setInvoiceId($invoiceId)
            ->setSenderTaxId($senderTaxId)
            ->setResult($result);
    }
    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return \StructType\InvoiceIDRecordResult
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get SenderTaxId value
     * @return string|null
     */
    public function getSenderTaxId()
    {
        return $this->SenderTaxId;
    }
    /**
     * Set SenderTaxId value
     * @param string $senderTaxId
     * @return \StructType\InvoiceIDRecordResult
     */
    public function setSenderTaxId($senderTaxId = null)
    {
        // validation for constraint: string
        if (!is_null($senderTaxId) && !is_string($senderTaxId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderTaxId, true), gettype($senderTaxId)), __LINE__);
        }
        $this->SenderTaxId = $senderTaxId;
        return $this;
    }
    /**
     * Get Result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param string $result
     * @return \StructType\InvoiceIDRecordResult
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
}
