<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetNewInvoiceId StructType
 * @subpackage Structs
 */
class GetNewInvoiceId extends AbstractStructBase
{
    /**
     * The Year
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Year;
    /**
     * The InvoiceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceType;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The TemplateCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateCode;
    /**
     * The reconciliationid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reconciliationid;
    /**
     * Constructor method for GetNewInvoiceId
     * @uses GetNewInvoiceId::setYear()
     * @uses GetNewInvoiceId::setInvoiceType()
     * @uses GetNewInvoiceId::setTicket()
     * @uses GetNewInvoiceId::setTemplateCode()
     * @uses GetNewInvoiceId::setReconciliationid()
     * @param int $year
     * @param int $invoiceType
     * @param string $ticket
     * @param string $templateCode
     * @param string $reconciliationid
     */
    public function __construct($year = null, $invoiceType = null, $ticket = null, $templateCode = null, $reconciliationid = null)
    {
        $this
            ->setYear($year)
            ->setInvoiceType($invoiceType)
            ->setTicket($ticket)
            ->setTemplateCode($templateCode)
            ->setReconciliationid($reconciliationid);
    }
    /**
     * Get Year value
     * @return int
     */
    public function getYear()
    {
        return $this->Year;
    }
    /**
     * Set Year value
     * @param int $year
     * @return \StructType\GetNewInvoiceId
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !(is_int($year) || ctype_digit($year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        $this->Year = $year;
        return $this;
    }
    /**
     * Get InvoiceType value
     * @return int
     */
    public function getInvoiceType()
    {
        return $this->InvoiceType;
    }
    /**
     * Set InvoiceType value
     * @param int $invoiceType
     * @return \StructType\GetNewInvoiceId
     */
    public function setInvoiceType($invoiceType = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceType) && !(is_int($invoiceType) || ctype_digit($invoiceType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceType, true), gettype($invoiceType)), __LINE__);
        }
        $this->InvoiceType = $invoiceType;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\GetNewInvoiceId
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get TemplateCode value
     * @return string|null
     */
    public function getTemplateCode()
    {
        return $this->TemplateCode;
    }
    /**
     * Set TemplateCode value
     * @param string $templateCode
     * @return \StructType\GetNewInvoiceId
     */
    public function setTemplateCode($templateCode = null)
    {
        // validation for constraint: string
        if (!is_null($templateCode) && !is_string($templateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateCode, true), gettype($templateCode)), __LINE__);
        }
        $this->TemplateCode = $templateCode;
        return $this;
    }
    /**
     * Get reconciliationid value
     * @return string|null
     */
    public function getReconciliationid()
    {
        return $this->reconciliationid;
    }
    /**
     * Set reconciliationid value
     * @param string $reconciliationid
     * @return \StructType\GetNewInvoiceId
     */
    public function setReconciliationid($reconciliationid = null)
    {
        // validation for constraint: string
        if (!is_null($reconciliationid) && !is_string($reconciliationid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reconciliationid, true), gettype($reconciliationid)), __LINE__);
        }
        $this->reconciliationid = $reconciliationid;
        return $this;
    }
}
