<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInvoiceImage StructType
 * @subpackage Structs
 */
class GetInvoiceImage extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The ImageFormat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImageFormat;
    /**
     * Constructor method for GetInvoiceImage
     * @uses GetInvoiceImage::setTicket()
     * @uses GetInvoiceImage::setUUID()
     * @uses GetInvoiceImage::setImageFormat()
     * @param string $ticket
     * @param string $uUID
     * @param string $imageFormat
     */
    public function __construct($ticket = null, $uUID = null, $imageFormat = null)
    {
        $this
            ->setTicket($ticket)
            ->setUUID($uUID)
            ->setImageFormat($imageFormat);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\GetInvoiceImage
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\GetInvoiceImage
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get ImageFormat value
     * @return string|null
     */
    public function getImageFormat()
    {
        return $this->ImageFormat;
    }
    /**
     * Set ImageFormat value
     * @param string $imageFormat
     * @return \StructType\GetInvoiceImage
     */
    public function setImageFormat($imageFormat = null)
    {
        // validation for constraint: string
        if (!is_null($imageFormat) && !is_string($imageFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageFormat, true), gettype($imageFormat)), __LINE__);
        }
        $this->ImageFormat = $imageFormat;
        return $this;
    }
}
