<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHashOfInvoice StructType
 * @subpackage Structs
 */
class GetHashOfInvoice extends AbstractStructBase
{
    /**
     * The InvoiceDirection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InvoiceDirection;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * Constructor method for GetHashOfInvoice
     * @uses GetHashOfInvoice::setInvoiceDirection()
     * @uses GetHashOfInvoice::setTicket()
     * @uses GetHashOfInvoice::setUUID()
     * @param string $invoiceDirection
     * @param string $ticket
     * @param string $uUID
     */
    public function __construct($invoiceDirection = null, $ticket = null, $uUID = null)
    {
        $this
            ->setInvoiceDirection($invoiceDirection)
            ->setTicket($ticket)
            ->setUUID($uUID);
    }
    /**
     * Get InvoiceDirection value
     * @return string
     */
    public function getInvoiceDirection()
    {
        return $this->InvoiceDirection;
    }
    /**
     * Set InvoiceDirection value
     * @uses \EnumType\Direction::valueIsValid()
     * @uses \EnumType\Direction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $invoiceDirection
     * @return \StructType\GetHashOfInvoice
     */
    public function setInvoiceDirection($invoiceDirection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Direction::valueIsValid($invoiceDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Direction', is_array($invoiceDirection) ? implode(', ', $invoiceDirection) : var_export($invoiceDirection, true), implode(', ', \EnumType\Direction::getValidValues())), __LINE__);
        }
        $this->InvoiceDirection = $invoiceDirection;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\GetHashOfInvoice
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\GetHashOfInvoice
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
}
