<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailableSentInvoicesByDate StructType
 * @subpackage Structs
 */
class GetAvailableSentInvoicesByDate extends AbstractStructBase
{
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The CorporateCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorporateCode;
    /**
     * Constructor method for GetAvailableSentInvoicesByDate
     * @uses GetAvailableSentInvoicesByDate::setStartDate()
     * @uses GetAvailableSentInvoicesByDate::setEndDate()
     * @uses GetAvailableSentInvoicesByDate::setTicket()
     * @uses GetAvailableSentInvoicesByDate::setCorporateCode()
     * @param string $startDate
     * @param string $endDate
     * @param string $ticket
     * @param string $corporateCode
     */
    public function __construct($startDate = null, $endDate = null, $ticket = null, $corporateCode = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setTicket($ticket)
            ->setCorporateCode($corporateCode);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\GetAvailableSentInvoicesByDate
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\GetAvailableSentInvoicesByDate
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\GetAvailableSentInvoicesByDate
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get CorporateCode value
     * @return string|null
     */
    public function getCorporateCode()
    {
        return $this->CorporateCode;
    }
    /**
     * Set CorporateCode value
     * @param string $corporateCode
     * @return \StructType\GetAvailableSentInvoicesByDate
     */
    public function setCorporateCode($corporateCode = null)
    {
        // validation for constraint: string
        if (!is_null($corporateCode) && !is_string($corporateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporateCode, true), gettype($corporateCode)), __LINE__);
        }
        $this->CorporateCode = $corporateCode;
        return $this;
    }
}
