<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnvelopeDownloadResult StructType
 * @subpackage Structs
 */
class EnvelopeDownloadResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The Invoices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvoiceStateResult
     */
    public $Invoices;
    /**
     * The ReturnValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnValue;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * The InstanceIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InstanceIdentifier;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Source;
    /**
     * Constructor method for EnvelopeDownloadResult
     * @uses EnvelopeDownloadResult::setServiceResult()
     * @uses EnvelopeDownloadResult::setErrorCode()
     * @uses EnvelopeDownloadResult::setInvoices()
     * @uses EnvelopeDownloadResult::setReturnValue()
     * @uses EnvelopeDownloadResult::setServiceResultDescription()
     * @uses EnvelopeDownloadResult::setInstanceIdentifier()
     * @uses EnvelopeDownloadResult::setSource()
     * @param string $serviceResult
     * @param int $errorCode
     * @param \ArrayType\ArrayOfInvoiceStateResult $invoices
     * @param string $returnValue
     * @param string $serviceResultDescription
     * @param string $instanceIdentifier
     * @param string $source
     */
    public function __construct($serviceResult = null, $errorCode = null, \ArrayType\ArrayOfInvoiceStateResult $invoices = null, $returnValue = null, $serviceResultDescription = null, $instanceIdentifier = null, $source = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setErrorCode($errorCode)
            ->setInvoices($invoices)
            ->setReturnValue($returnValue)
            ->setServiceResultDescription($serviceResultDescription)
            ->setInstanceIdentifier($instanceIdentifier)
            ->setSource($source);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\EnvelopeDownloadResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\EnvelopeDownloadResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get Invoices value
     * @return \ArrayType\ArrayOfInvoiceStateResult|null
     */
    public function getInvoices()
    {
        return $this->Invoices;
    }
    /**
     * Set Invoices value
     * @param \ArrayType\ArrayOfInvoiceStateResult $invoices
     * @return \StructType\EnvelopeDownloadResult
     */
    public function setInvoices(\ArrayType\ArrayOfInvoiceStateResult $invoices = null)
    {
        $this->Invoices = $invoices;
        return $this;
    }
    /**
     * Get ReturnValue value
     * @return string|null
     */
    public function getReturnValue()
    {
        return $this->ReturnValue;
    }
    /**
     * Set ReturnValue value
     * @param string $returnValue
     * @return \StructType\EnvelopeDownloadResult
     */
    public function setReturnValue($returnValue = null)
    {
        // validation for constraint: string
        if (!is_null($returnValue) && !is_string($returnValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnValue, true), gettype($returnValue)), __LINE__);
        }
        $this->ReturnValue = $returnValue;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\EnvelopeDownloadResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
    /**
     * Get InstanceIdentifier value
     * @return string|null
     */
    public function getInstanceIdentifier()
    {
        return $this->InstanceIdentifier;
    }
    /**
     * Set InstanceIdentifier value
     * @param string $instanceIdentifier
     * @return \StructType\EnvelopeDownloadResult
     */
    public function setInstanceIdentifier($instanceIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($instanceIdentifier) && !is_string($instanceIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instanceIdentifier, true), gettype($instanceIdentifier)), __LINE__);
        }
        $this->InstanceIdentifier = $instanceIdentifier;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\EnvelopeDownloadResult
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
}
