<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EArchiveReportResult StructType
 * @subpackage Structs
 */
class EArchiveReportResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusCode;
    /**
     * The StartPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartPeriod;
    /**
     * The EndPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndPeriod;
    /**
     * The StartPart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartPart;
    /**
     * The EndPart
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndPart;
    /**
     * The PartNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PartNo;
    /**
     * The InvoiceCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceCount;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * The StatusDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusDescription;
    /**
     * The ReportNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReportNo;
    /**
     * The ReportData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReportData;
    /**
     * Constructor method for EArchiveReportResult
     * @uses EArchiveReportResult::setServiceResult()
     * @uses EArchiveReportResult::setErrorCode()
     * @uses EArchiveReportResult::setStatusCode()
     * @uses EArchiveReportResult::setStartPeriod()
     * @uses EArchiveReportResult::setEndPeriod()
     * @uses EArchiveReportResult::setStartPart()
     * @uses EArchiveReportResult::setEndPart()
     * @uses EArchiveReportResult::setPartNo()
     * @uses EArchiveReportResult::setInvoiceCount()
     * @uses EArchiveReportResult::setServiceResultDescription()
     * @uses EArchiveReportResult::setStatusDescription()
     * @uses EArchiveReportResult::setReportNo()
     * @uses EArchiveReportResult::setReportData()
     * @param string $serviceResult
     * @param int $errorCode
     * @param int $statusCode
     * @param string $startPeriod
     * @param string $endPeriod
     * @param string $startPart
     * @param string $endPart
     * @param int $partNo
     * @param int $invoiceCount
     * @param string $serviceResultDescription
     * @param string $statusDescription
     * @param string $reportNo
     * @param string $reportData
     */
    public function __construct($serviceResult = null, $errorCode = null, $statusCode = null, $startPeriod = null, $endPeriod = null, $startPart = null, $endPart = null, $partNo = null, $invoiceCount = null, $serviceResultDescription = null, $statusDescription = null, $reportNo = null, $reportData = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setErrorCode($errorCode)
            ->setStatusCode($statusCode)
            ->setStartPeriod($startPeriod)
            ->setEndPeriod($endPeriod)
            ->setStartPart($startPart)
            ->setEndPart($endPart)
            ->setPartNo($partNo)
            ->setInvoiceCount($invoiceCount)
            ->setServiceResultDescription($serviceResultDescription)
            ->setStatusDescription($statusDescription)
            ->setReportNo($reportNo)
            ->setReportData($reportData);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\EArchiveReportResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\EArchiveReportResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \StructType\EArchiveReportResult
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get StartPeriod value
     * @return string
     */
    public function getStartPeriod()
    {
        return $this->StartPeriod;
    }
    /**
     * Set StartPeriod value
     * @param string $startPeriod
     * @return \StructType\EArchiveReportResult
     */
    public function setStartPeriod($startPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($startPeriod) && !is_string($startPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startPeriod, true), gettype($startPeriod)), __LINE__);
        }
        $this->StartPeriod = $startPeriod;
        return $this;
    }
    /**
     * Get EndPeriod value
     * @return string
     */
    public function getEndPeriod()
    {
        return $this->EndPeriod;
    }
    /**
     * Set EndPeriod value
     * @param string $endPeriod
     * @return \StructType\EArchiveReportResult
     */
    public function setEndPeriod($endPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($endPeriod) && !is_string($endPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endPeriod, true), gettype($endPeriod)), __LINE__);
        }
        $this->EndPeriod = $endPeriod;
        return $this;
    }
    /**
     * Get StartPart value
     * @return string
     */
    public function getStartPart()
    {
        return $this->StartPart;
    }
    /**
     * Set StartPart value
     * @param string $startPart
     * @return \StructType\EArchiveReportResult
     */
    public function setStartPart($startPart = null)
    {
        // validation for constraint: string
        if (!is_null($startPart) && !is_string($startPart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startPart, true), gettype($startPart)), __LINE__);
        }
        $this->StartPart = $startPart;
        return $this;
    }
    /**
     * Get EndPart value
     * @return string
     */
    public function getEndPart()
    {
        return $this->EndPart;
    }
    /**
     * Set EndPart value
     * @param string $endPart
     * @return \StructType\EArchiveReportResult
     */
    public function setEndPart($endPart = null)
    {
        // validation for constraint: string
        if (!is_null($endPart) && !is_string($endPart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endPart, true), gettype($endPart)), __LINE__);
        }
        $this->EndPart = $endPart;
        return $this;
    }
    /**
     * Get PartNo value
     * @return int
     */
    public function getPartNo()
    {
        return $this->PartNo;
    }
    /**
     * Set PartNo value
     * @param int $partNo
     * @return \StructType\EArchiveReportResult
     */
    public function setPartNo($partNo = null)
    {
        // validation for constraint: int
        if (!is_null($partNo) && !(is_int($partNo) || ctype_digit($partNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partNo, true), gettype($partNo)), __LINE__);
        }
        $this->PartNo = $partNo;
        return $this;
    }
    /**
     * Get InvoiceCount value
     * @return int
     */
    public function getInvoiceCount()
    {
        return $this->InvoiceCount;
    }
    /**
     * Set InvoiceCount value
     * @param int $invoiceCount
     * @return \StructType\EArchiveReportResult
     */
    public function setInvoiceCount($invoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceCount) && !(is_int($invoiceCount) || ctype_digit($invoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceCount, true), gettype($invoiceCount)), __LINE__);
        }
        $this->InvoiceCount = $invoiceCount;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\EArchiveReportResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
    /**
     * Get StatusDescription value
     * @return string|null
     */
    public function getStatusDescription()
    {
        return $this->StatusDescription;
    }
    /**
     * Set StatusDescription value
     * @param string $statusDescription
     * @return \StructType\EArchiveReportResult
     */
    public function setStatusDescription($statusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($statusDescription) && !is_string($statusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDescription, true), gettype($statusDescription)), __LINE__);
        }
        $this->StatusDescription = $statusDescription;
        return $this;
    }
    /**
     * Get ReportNo value
     * @return string|null
     */
    public function getReportNo()
    {
        return $this->ReportNo;
    }
    /**
     * Set ReportNo value
     * @param string $reportNo
     * @return \StructType\EArchiveReportResult
     */
    public function setReportNo($reportNo = null)
    {
        // validation for constraint: string
        if (!is_null($reportNo) && !is_string($reportNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportNo, true), gettype($reportNo)), __LINE__);
        }
        $this->ReportNo = $reportNo;
        return $this;
    }
    /**
     * Get ReportData value
     * @return string|null
     */
    public function getReportData()
    {
        return $this->ReportData;
    }
    /**
     * Set ReportData value
     * @param string $reportData
     * @return \StructType\EArchiveReportResult
     */
    public function setReportData($reportData = null)
    {
        // validation for constraint: string
        if (!is_null($reportData) && !is_string($reportData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportData, true), gettype($reportData)), __LINE__);
        }
        $this->ReportData = $reportData;
        return $this;
    }
}
