<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteEArchiveInvoice StructType
 * @subpackage Structs
 */
class DeleteEArchiveInvoice extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The InvoiceNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumberType;
    /**
     * Constructor method for DeleteEArchiveInvoice
     * @uses DeleteEArchiveInvoice::setTicket()
     * @uses DeleteEArchiveInvoice::setInvoiceNumber()
     * @uses DeleteEArchiveInvoice::setInvoiceNumberType()
     * @param string $ticket
     * @param string $invoiceNumber
     * @param string $invoiceNumberType
     */
    public function __construct($ticket = null, $invoiceNumber = null, $invoiceNumberType = null)
    {
        $this
            ->setTicket($ticket)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceNumberType($invoiceNumberType);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\DeleteEArchiveInvoice
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\DeleteEArchiveInvoice
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get InvoiceNumberType value
     * @return string|null
     */
    public function getInvoiceNumberType()
    {
        return $this->InvoiceNumberType;
    }
    /**
     * Set InvoiceNumberType value
     * @param string $invoiceNumberType
     * @return \StructType\DeleteEArchiveInvoice
     */
    public function setInvoiceNumberType($invoiceNumberType = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumberType) && !is_string($invoiceNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumberType, true), gettype($invoiceNumberType)), __LINE__);
        }
        $this->InvoiceNumberType = $invoiceNumberType;
        return $this;
    }
}
