<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckInvoiceStateWithReconciliationID StructType
 * @subpackage Structs
 */
class CheckInvoiceStateWithReconciliationID extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The ReconciliationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReconciliationId;
    /**
     * Constructor method for CheckInvoiceStateWithReconciliationID
     * @uses CheckInvoiceStateWithReconciliationID::setTicket()
     * @uses CheckInvoiceStateWithReconciliationID::setReconciliationId()
     * @param string $ticket
     * @param string $reconciliationId
     */
    public function __construct($ticket = null, $reconciliationId = null)
    {
        $this
            ->setTicket($ticket)
            ->setReconciliationId($reconciliationId);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\CheckInvoiceStateWithReconciliationID
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get ReconciliationId value
     * @return string|null
     */
    public function getReconciliationId()
    {
        return $this->ReconciliationId;
    }
    /**
     * Set ReconciliationId value
     * @param string $reconciliationId
     * @return \StructType\CheckInvoiceStateWithReconciliationID
     */
    public function setReconciliationId($reconciliationId = null)
    {
        // validation for constraint: string
        if (!is_null($reconciliationId) && !is_string($reconciliationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reconciliationId, true), gettype($reconciliationId)), __LINE__);
        }
        $this->ReconciliationId = $reconciliationId;
        return $this;
    }
}
