<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckEnvelopeState StructType
 * @subpackage Structs
 */
class CheckEnvelopeState extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The InstanceIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InstanceIdentifier;
    /**
     * Constructor method for CheckEnvelopeState
     * @uses CheckEnvelopeState::setTicket()
     * @uses CheckEnvelopeState::setInstanceIdentifier()
     * @param string $ticket
     * @param string $instanceIdentifier
     */
    public function __construct($ticket = null, $instanceIdentifier = null)
    {
        $this
            ->setTicket($ticket)
            ->setInstanceIdentifier($instanceIdentifier);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\CheckEnvelopeState
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get InstanceIdentifier value
     * @return string|null
     */
    public function getInstanceIdentifier()
    {
        return $this->InstanceIdentifier;
    }
    /**
     * Set InstanceIdentifier value
     * @param string $instanceIdentifier
     * @return \StructType\CheckEnvelopeState
     */
    public function setInstanceIdentifier($instanceIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($instanceIdentifier) && !is_string($instanceIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instanceIdentifier, true), gettype($instanceIdentifier)), __LINE__);
        }
        $this->InstanceIdentifier = $instanceIdentifier;
        return $this;
    }
}
