<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckEArchiveReportState StructType
 * @subpackage Structs
 */
class CheckEArchiveReportState extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The ReportNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReportNo;
    /**
     * Constructor method for CheckEArchiveReportState
     * @uses CheckEArchiveReportState::setTicket()
     * @uses CheckEArchiveReportState::setReportNo()
     * @param string $ticket
     * @param string $reportNo
     */
    public function __construct($ticket = null, $reportNo = null)
    {
        $this
            ->setTicket($ticket)
            ->setReportNo($reportNo);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\CheckEArchiveReportState
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get ReportNo value
     * @return string|null
     */
    public function getReportNo()
    {
        return $this->ReportNo;
    }
    /**
     * Set ReportNo value
     * @param string $reportNo
     * @return \StructType\CheckEArchiveReportState
     */
    public function setReportNo($reportNo = null)
    {
        // validation for constraint: string
        if (!is_null($reportNo) && !is_string($reportNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportNo, true), gettype($reportNo)), __LINE__);
        }
        $this->ReportNo = $reportNo;
        return $this;
    }
}
