<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Out ServiceType
 * @subpackage Services
 */
class Out extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OutSidersSendEmail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OutSidersSendEmail $parameters
     * @return \StructType\OutSidersSendEmailResponse|bool
     */
    public function OutSidersSendEmail(\StructType\OutSidersSendEmail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OutSidersSendEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OutSidersSendEmailResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
