<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetAvailableApplicationResponses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailableApplicationResponses $parameters
     * @return \StructType\GetAvailableApplicationResponsesResponse|bool
     */
    public function GetAvailableApplicationResponses(\StructType\GetAvailableApplicationResponses $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableApplicationResponses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEInvoiceSenderListUpdates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEInvoiceSenderListUpdates $parameters
     * @return \StructType\GetEInvoiceSenderListUpdatesResponse|bool
     */
    public function GetEInvoiceSenderListUpdates(\StructType\GetEInvoiceSenderListUpdates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEInvoiceSenderListUpdates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEInvoiceReceiverListUpdates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEInvoiceReceiverListUpdates $parameters
     * @return \StructType\GetEInvoiceReceiverListUpdatesResponse|bool
     */
    public function GetEInvoiceReceiverListUpdates(\StructType\GetEInvoiceReceiverListUpdates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEInvoiceReceiverListUpdates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableInvoiceReturnStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailableInvoiceReturnStatus $parameters
     * @return \StructType\GetAvailableInvoiceReturnStatusResponse|bool
     */
    public function GetAvailableInvoiceReturnStatus(\StructType\GetAvailableInvoiceReturnStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableInvoiceReturnStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceByInvoiceID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceByInvoiceID $parameters
     * @return \StructType\GetInvoiceByInvoiceIDResponse|bool
     */
    public function GetInvoiceByInvoiceID(\StructType\GetInvoiceByInvoiceID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceByInvoiceID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInboundInvoiceByMapCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInboundInvoiceByMapCode $parameters
     * @return \StructType\GetInboundInvoiceByMapCodeResponse|bool
     */
    public function GetInboundInvoiceByMapCode(\StructType\GetInboundInvoiceByMapCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInboundInvoiceByMapCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEnvelope
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEnvelope $parameters
     * @return \StructType\GetEnvelopeResponse|bool
     */
    public function GetEnvelope(\StructType\GetEnvelope $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEnvelope($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableInvoices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailableInvoices $parameters
     * @return \StructType\GetAvailableInvoicesResponse|bool
     */
    public function GetAvailableInvoices(\StructType\GetAvailableInvoices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableInvoices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableInvoicesPW
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailableInvoicesPW $parameters
     * @return \StructType\GetAvailableInvoicesPWResponse|bool
     */
    public function GetAvailableInvoicesPW(\StructType\GetAvailableInvoicesPW $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableInvoicesPW($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableCompletedInvoices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailableCompletedInvoices $parameters
     * @return \StructType\GetAvailableCompletedInvoicesResponse|bool
     */
    public function GetAvailableCompletedInvoices(\StructType\GetAvailableCompletedInvoices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableCompletedInvoices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableInvoicesByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailableInvoicesByDate $parameters
     * @return \StructType\GetAvailableInvoicesByDateResponse|bool
     */
    public function GetAvailableInvoicesByDate(\StructType\GetAvailableInvoicesByDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableInvoicesByDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableInvoicesWithDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailableInvoicesWithDate $parameters
     * @return \StructType\GetAvailableInvoicesWithDateResponse|bool
     */
    public function GetAvailableInvoicesWithDate(\StructType\GetAvailableInvoicesWithDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableInvoicesWithDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetIncomingInvoicesByIssueDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIncomingInvoicesByIssueDate $parameters
     * @return \StructType\GetIncomingInvoicesByIssueDateResponse|bool
     */
    public function GetIncomingInvoicesByIssueDate(\StructType\GetIncomingInvoicesByIssueDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetIncomingInvoicesByIssueDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEArchiveReportList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEArchiveReportList $parameters
     * @return \StructType\GetEArchiveReportListResponse|bool
     */
    public function GetEArchiveReportList(\StructType\GetEArchiveReportList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEArchiveReportList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEArchiveReportListWithPeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEArchiveReportListWithPeriod $parameters
     * @return \StructType\GetEArchiveReportListWithPeriodResponse|bool
     */
    public function GetEArchiveReportListWithPeriod(\StructType\GetEArchiveReportListWithPeriod $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEArchiveReportListWithPeriod($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoice $parameters
     * @return \StructType\GetInvoiceResponse|bool
     */
    public function GetInvoice(\StructType\GetInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoicePW
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoicePW $parameters
     * @return \StructType\GetInvoicePWResponse|bool
     */
    public function GetInvoicePW(\StructType\GetInvoicePW $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoicePW($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceAllDirection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceAllDirection $parameters
     * @return \StructType\GetInvoiceAllDirectionResponse|bool
     */
    public function GetInvoiceAllDirection(\StructType\GetInvoiceAllDirection $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceAllDirection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoicePDF
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoicePDF $parameters
     * @return \StructType\GetInvoicePDFResponse|bool
     */
    public function GetInvoicePDF(\StructType\GetInvoicePDF $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoicePDF($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoicePDFByInvoiceId
     * Meta information extracted from the WSDL
     * - documentation: Getting PDF of the E-Invoice with using InvoiceId which has 16 digits and is required by Government.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoicePDFByInvoiceId $parameters
     * @return \StructType\GetInvoicePDFByInvoiceIdResponse|bool
     */
    public function GetInvoicePDFByInvoiceId(\StructType\GetInvoicePDFByInvoiceId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoicePDFByInvoiceId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetInvoicePDFByInvoiceIdWithoutDirection
     * Meta information extracted from the WSDL
     * - documentation: Getting PDF of the E-Invoice with using InvoiceId which has 16 digits and is required by Government.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoicePDFByInvoiceIdWithoutDirection $parameters
     * @return \StructType\GetInvoicePDFByInvoiceIdWithoutDirectionResponse|bool
     */
    public function GetInvoicePDFByInvoiceIdWithoutDirection(\StructType\GetInvoicePDFByInvoiceIdWithoutDirection $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoicePDFByInvoiceIdWithoutDirection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceImage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceImage $parameters
     * @return \StructType\GetInvoiceImageResponse|bool
     */
    public function GetInvoiceImage(\StructType\GetInvoiceImage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceImage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceTemplate $parameters
     * @return \StructType\GetInvoiceTemplateResponse|bool
     */
    public function GetInvoiceTemplate(\StructType\GetInvoiceTemplate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEArchiveInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEArchiveInvoice $parameters
     * @return \StructType\GetEArchiveInvoiceResponse|bool
     */
    public function GetEArchiveInvoice(\StructType\GetEArchiveInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEArchiveInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEArchiveIncomingInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEArchiveIncomingInvoice $parameters
     * @return \StructType\GetEArchiveIncomingInvoiceResponse|bool
     */
    public function GetEArchiveIncomingInvoice(\StructType\GetEArchiveIncomingInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEArchiveIncomingInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEArchiveReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEArchiveReport $parameters
     * @return \StructType\GetEArchiveReportResponse|bool
     */
    public function GetEArchiveReport(\StructType\GetEArchiveReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEArchiveReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceXML $parameters
     * @return \StructType\GetInvoiceXMLResponse|bool
     */
    public function GetInvoiceXML(\StructType\GetInvoiceXML $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceXMLWithOutFlag
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceXMLWithOutFlag $parameters
     * @return \StructType\GetInvoiceXMLWithOutFlagResponse|bool
     */
    public function GetInvoiceXMLWithOutFlag(\StructType\GetInvoiceXMLWithOutFlag $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceXMLWithOutFlag($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceWithOutFlag
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceWithOutFlag $parameters
     * @return \StructType\GetInvoiceWithOutFlagResponse|bool
     */
    public function GetInvoiceWithOutFlag(\StructType\GetInvoiceWithOutFlag $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceWithOutFlag($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTaxIdListbyDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTaxIdListbyDate $parameters
     * @return \StructType\GetTaxIdListbyDateResponse|bool
     */
    public function GetTaxIdListbyDate(\StructType\GetTaxIdListbyDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTaxIdListbyDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEInvoiceCustomerListByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEInvoiceCustomerListByDate $parameters
     * @return \StructType\GetEInvoiceCustomerListByDateResponse|bool
     */
    public function GetEInvoiceCustomerListByDate(\StructType\GetEInvoiceCustomerListByDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEInvoiceCustomerListByDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEInvoiceCustomerFullList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEInvoiceCustomerFullList $parameters
     * @return \StructType\GetEInvoiceCustomerFullListResponse|bool
     */
    public function GetEInvoiceCustomerFullList(\StructType\GetEInvoiceCustomerFullList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEInvoiceCustomerFullList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFormsAuthenticationTicket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFormsAuthenticationTicket $parameters
     * @return \StructType\GetFormsAuthenticationTicketResponse|bool
     */
    public function GetFormsAuthenticationTicket(\StructType\GetFormsAuthenticationTicket $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFormsAuthenticationTicket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFormsAuthenticationTicketPW
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFormsAuthenticationTicketPW $parameters
     * @return \StructType\GetFormsAuthenticationTicketPWResponse|bool
     */
    public function GetFormsAuthenticationTicketPW(\StructType\GetFormsAuthenticationTicketPW $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFormsAuthenticationTicketPW($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceSummary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceSummary $parameters
     * @return \StructType\GetInvoiceSummaryResponse|bool
     */
    public function GetInvoiceSummary(\StructType\GetInvoiceSummary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceSummary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceSummaryWithDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceSummaryWithDate $parameters
     * @return \StructType\GetInvoiceSummaryWithDateResponse|bool
     */
    public function GetInvoiceSummaryWithDate(\StructType\GetInvoiceSummaryWithDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceSummaryWithDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceCountWithDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceCountWithDate $parameters
     * @return \StructType\GetInvoiceCountWithDateResponse|bool
     */
    public function GetInvoiceCountWithDate(\StructType\GetInvoiceCountWithDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceCountWithDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerDifferenceXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerDifferenceXml $parameters
     * @return \StructType\GetCustomerDifferenceXmlResponse|bool
     */
    public function GetCustomerDifferenceXml(\StructType\GetCustomerDifferenceXml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerDifferenceXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerDifferenceBase64Xml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerDifferenceBase64Xml $parameters
     * @return \StructType\GetCustomerDifferenceBase64XmlResponse|bool
     */
    public function GetCustomerDifferenceBase64Xml(\StructType\GetCustomerDifferenceBase64Xml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerDifferenceBase64Xml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableSentInvoicesByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailableSentInvoicesByDate $parameters
     * @return \StructType\GetAvailableSentInvoicesByDateResponse|bool
     */
    public function GetAvailableSentInvoicesByDate(\StructType\GetAvailableSentInvoicesByDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableSentInvoicesByDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAvailableSentInvoicesByIssueDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailableSentInvoicesByIssueDate $parameters
     * @return \StructType\GetAvailableSentInvoicesByIssueDateResponse|bool
     */
    public function GetAvailableSentInvoicesByIssueDate(\StructType\GetAvailableSentInvoicesByIssueDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableSentInvoicesByIssueDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHashOfInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHashOfInvoice $parameters
     * @return \StructType\GetHashOfInvoiceResponse|bool
     */
    public function GetHashOfInvoice(\StructType\GetHashOfInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetHashOfInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEArchiveInvoicesByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEArchiveInvoicesByDate $parameters
     * @return \StructType\GetEArchiveInvoicesByDateResponse|bool
     */
    public function GetEArchiveInvoicesByDate(\StructType\GetEArchiveInvoicesByDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEArchiveInvoicesByDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEArchiveInvoicesWithDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEArchiveInvoicesWithDate $parameters
     * @return \StructType\GetEArchiveInvoicesWithDateResponse|bool
     */
    public function GetEArchiveInvoicesWithDate(\StructType\GetEArchiveInvoicesWithDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEArchiveInvoicesWithDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetEArchiveInvoicesWithIssueDateAndTaxNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEArchiveInvoicesWithIssueDateAndTaxNumber $parameters
     * @return \StructType\GetEArchiveInvoicesWithIssueDateAndTaxNumberResponse|bool
     */
    public function GetEArchiveInvoicesWithIssueDateAndTaxNumber(\StructType\GetEArchiveInvoicesWithIssueDateAndTaxNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEArchiveInvoicesWithIssueDateAndTaxNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInvoiceHTML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInvoiceHTML $parameters
     * @return \StructType\GetInvoiceHTMLResponse|bool
     */
    public function GetInvoiceHTML(\StructType\GetInvoiceHTML $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInvoiceHTML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEArchiveInvoicesByReportNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEArchiveInvoicesByReportNo $parameters
     * @return \StructType\GetEArchiveInvoicesByReportNoResponse|bool
     */
    public function GetEArchiveInvoicesByReportNo(\StructType\GetEArchiveInvoicesByReportNo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEArchiveInvoicesByReportNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNewInvoiceId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewInvoiceId $parameters
     * @return \StructType\GetNewInvoiceIdResponse|bool
     */
    public function GetNewInvoiceId(\StructType\GetNewInvoiceId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNewInvoiceId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReconciliationEArchiveByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReconciliationEArchiveByDate $parameters
     * @return \StructType\GetReconciliationEArchiveByDateResponse|bool
     */
    public function GetReconciliationEArchiveByDate(\StructType\GetReconciliationEArchiveByDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReconciliationEArchiveByDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetReconciliationEArchiveByDateExtended
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReconciliationEArchiveByDateExtended $parameters
     * @return \StructType\GetReconciliationEArchiveByDateExtendedResponse|bool
     */
    public function GetReconciliationEArchiveByDateExtended(\StructType\GetReconciliationEArchiveByDateExtended $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReconciliationEArchiveByDateExtended($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGTBRefAndRegisterNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGTBRefAndRegisterNumber $parameters
     * @return \StructType\GetGTBRefAndRegisterNumberResponse|bool
     */
    public function GetGTBRefAndRegisterNumber(\StructType\GetGTBRefAndRegisterNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGTBRefAndRegisterNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetIncomingInvoiceBranchInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIncomingInvoiceBranchInfo $parameters
     * @return \StructType\GetIncomingInvoiceBranchInfoResponse|bool
     */
    public function GetIncomingInvoiceBranchInfo(\StructType\GetIncomingInvoiceBranchInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetIncomingInvoiceBranchInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAvailableApplicationResponsesResponse|\StructType\GetAvailableCompletedInvoicesResponse|\StructType\GetAvailableInvoiceReturnStatusResponse|\StructType\GetAvailableInvoicesByDateResponse|\StructType\GetAvailableInvoicesPWResponse|\StructType\GetAvailableInvoicesResponse|\StructType\GetAvailableInvoicesWithDateResponse|\StructType\GetAvailableSentInvoicesByDateResponse|\StructType\GetAvailableSentInvoicesByIssueDateResponse|\StructType\GetCustomerDifferenceBase64XmlResponse|\StructType\GetCustomerDifferenceXmlResponse|\StructType\GetEArchiveIncomingInvoiceResponse|\StructType\GetEArchiveInvoiceResponse|\StructType\GetEArchiveInvoicesByDateResponse|\StructType\GetEArchiveInvoicesByReportNoResponse|\StructType\GetEArchiveInvoicesWithDateResponse|\StructType\GetEArchiveInvoicesWithIssueDateAndTaxNumberResponse|\StructType\GetEArchiveReportListResponse|\StructType\GetEArchiveReportListWithPeriodResponse|\StructType\GetEArchiveReportResponse|\StructType\GetEInvoiceCustomerFullListResponse|\StructType\GetEInvoiceCustomerListByDateResponse|\StructType\GetEInvoiceReceiverListUpdatesResponse|\StructType\GetEInvoiceSenderListUpdatesResponse|\StructType\GetEnvelopeResponse|\StructType\GetFormsAuthenticationTicketPWResponse|\StructType\GetFormsAuthenticationTicketResponse|\StructType\GetGTBRefAndRegisterNumberResponse|\StructType\GetHashOfInvoiceResponse|\StructType\GetInboundInvoiceByMapCodeResponse|\StructType\GetIncomingInvoiceBranchInfoResponse|\StructType\GetIncomingInvoicesByIssueDateResponse|\StructType\GetInvoiceAllDirectionResponse|\StructType\GetInvoiceByInvoiceIDResponse|\StructType\GetInvoiceCountWithDateResponse|\StructType\GetInvoiceHTMLResponse|\StructType\GetInvoiceImageResponse|\StructType\GetInvoicePDFByInvoiceIdResponse|\StructType\GetInvoicePDFByInvoiceIdWithoutDirectionResponse|\StructType\GetInvoicePDFResponse|\StructType\GetInvoicePWResponse|\StructType\GetInvoiceResponse|\StructType\GetInvoiceSummaryResponse|\StructType\GetInvoiceSummaryWithDateResponse|\StructType\GetInvoiceTemplateResponse|\StructType\GetInvoiceWithOutFlagResponse|\StructType\GetInvoiceXMLResponse|\StructType\GetInvoiceXMLWithOutFlagResponse|\StructType\GetNewInvoiceIdResponse|\StructType\GetReconciliationEArchiveByDateExtendedResponse|\StructType\GetReconciliationEArchiveByDateResponse|\StructType\GetTaxIdListbyDateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
