<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoiceInfoQuery ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoiceInfoQuery extends AbstractStructArrayBase
{
    /**
     * The InvoiceInfoQuery
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceInfoQuery[]
     */
    public $InvoiceInfoQuery;
    /**
     * Constructor method for ArrayOfInvoiceInfoQuery
     * @uses ArrayOfInvoiceInfoQuery::setInvoiceInfoQuery()
     * @param \StructType\InvoiceInfoQuery[] $invoiceInfoQuery
     */
    public function __construct(array $invoiceInfoQuery = array())
    {
        $this
            ->setInvoiceInfoQuery($invoiceInfoQuery);
    }
    /**
     * Get InvoiceInfoQuery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceInfoQuery[]|null
     */
    public function getInvoiceInfoQuery()
    {
        return isset($this->InvoiceInfoQuery) ? $this->InvoiceInfoQuery : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceInfoQuery method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceInfoQuery method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceInfoQueryForArrayConstraintsFromSetInvoiceInfoQuery(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoiceInfoQueryInvoiceInfoQueryItem) {
            // validation for constraint: itemType
            if (!$arrayOfInvoiceInfoQueryInvoiceInfoQueryItem instanceof \StructType\InvoiceInfoQuery) {
                $invalidValues[] = is_object($arrayOfInvoiceInfoQueryInvoiceInfoQueryItem) ? get_class($arrayOfInvoiceInfoQueryInvoiceInfoQueryItem) : sprintf('%s(%s)', gettype($arrayOfInvoiceInfoQueryInvoiceInfoQueryItem), var_export($arrayOfInvoiceInfoQueryInvoiceInfoQueryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceInfoQuery property can only contain items of type \StructType\InvoiceInfoQuery, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceInfoQuery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceInfoQuery[] $invoiceInfoQuery
     * @return \ArrayType\ArrayOfInvoiceInfoQuery
     */
    public function setInvoiceInfoQuery(array $invoiceInfoQuery = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceInfoQueryArrayErrorMessage = self::validateInvoiceInfoQueryForArrayConstraintsFromSetInvoiceInfoQuery($invoiceInfoQuery))) {
            throw new \InvalidArgumentException($invoiceInfoQueryArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceInfoQuery) || (is_array($invoiceInfoQuery) && empty($invoiceInfoQuery))) {
            unset($this->InvoiceInfoQuery);
        } else {
            $this->InvoiceInfoQuery = $invoiceInfoQuery;
        }
        return $this;
    }
    /**
     * Add item to InvoiceInfoQuery value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceInfoQuery $item
     * @return \ArrayType\ArrayOfInvoiceInfoQuery
     */
    public function addToInvoiceInfoQuery(\StructType\InvoiceInfoQuery $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceInfoQuery) {
            throw new \InvalidArgumentException(sprintf('The InvoiceInfoQuery property can only contain items of type \StructType\InvoiceInfoQuery, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceInfoQuery[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InvoiceInfoQuery|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InvoiceInfoQuery|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InvoiceInfoQuery|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InvoiceInfoQuery|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InvoiceInfoQuery|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoiceInfoQuery
     */
    public function getAttributeName()
    {
        return 'InvoiceInfoQuery';
    }
}
