<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContourInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfContourInfo extends AbstractStructArrayBase
{
    /**
     * The ContourInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContourInfo[]
     */
    public $ContourInfo;
    /**
     * Constructor method for ArrayOfContourInfo
     * @uses ArrayOfContourInfo::setContourInfo()
     * @param \StructType\ContourInfo[] $contourInfo
     */
    public function __construct(array $contourInfo = array())
    {
        $this
            ->setContourInfo($contourInfo);
    }
    /**
     * Get ContourInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContourInfo[]|null
     */
    public function getContourInfo()
    {
        return isset($this->ContourInfo) ? $this->ContourInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setContourInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContourInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContourInfoForArrayConstraintsFromSetContourInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfContourInfoContourInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfContourInfoContourInfoItem instanceof \StructType\ContourInfo) {
                $invalidValues[] = is_object($arrayOfContourInfoContourInfoItem) ? get_class($arrayOfContourInfoContourInfoItem) : sprintf('%s(%s)', gettype($arrayOfContourInfoContourInfoItem), var_export($arrayOfContourInfoContourInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContourInfo property can only contain items of type \StructType\ContourInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContourInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContourInfo[] $contourInfo
     * @return \ArrayType\ArrayOfContourInfo
     */
    public function setContourInfo(array $contourInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($contourInfoArrayErrorMessage = self::validateContourInfoForArrayConstraintsFromSetContourInfo($contourInfo))) {
            throw new \InvalidArgumentException($contourInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($contourInfo) || (is_array($contourInfo) && empty($contourInfo))) {
            unset($this->ContourInfo);
        } else {
            $this->ContourInfo = $contourInfo;
        }
        return $this;
    }
    /**
     * Add item to ContourInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContourInfo $item
     * @return \ArrayType\ArrayOfContourInfo
     */
    public function addToContourInfo(\StructType\ContourInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContourInfo) {
            throw new \InvalidArgumentException(sprintf('The ContourInfo property can only contain items of type \StructType\ContourInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContourInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ContourInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ContourInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ContourInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ContourInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ContourInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContourInfo
     */
    public function getAttributeName()
    {
        return 'ContourInfo';
    }
}
