<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendTaxFreeInvoiceData StructType
 * @subpackage Structs
 */
class SendTaxFreeInvoiceData extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The InvoiceRawData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceRawData;
    /**
     * The CorporateCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorporateCode;
    /**
     * The TemplateCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateCode;
    /**
     * Constructor method for SendTaxFreeInvoiceData
     * @uses SendTaxFreeInvoiceData::setTicket()
     * @uses SendTaxFreeInvoiceData::setInvoiceRawData()
     * @uses SendTaxFreeInvoiceData::setCorporateCode()
     * @uses SendTaxFreeInvoiceData::setTemplateCode()
     * @param string $ticket
     * @param string $invoiceRawData
     * @param string $corporateCode
     * @param string $templateCode
     */
    public function __construct($ticket = null, $invoiceRawData = null, $corporateCode = null, $templateCode = null)
    {
        $this
            ->setTicket($ticket)
            ->setInvoiceRawData($invoiceRawData)
            ->setCorporateCode($corporateCode)
            ->setTemplateCode($templateCode);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\SendTaxFreeInvoiceData
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get InvoiceRawData value
     * @return string|null
     */
    public function getInvoiceRawData()
    {
        return $this->InvoiceRawData;
    }
    /**
     * Set InvoiceRawData value
     * @param string $invoiceRawData
     * @return \StructType\SendTaxFreeInvoiceData
     */
    public function setInvoiceRawData($invoiceRawData = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceRawData) && !is_string($invoiceRawData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceRawData, true), gettype($invoiceRawData)), __LINE__);
        }
        $this->InvoiceRawData = $invoiceRawData;
        return $this;
    }
    /**
     * Get CorporateCode value
     * @return string|null
     */
    public function getCorporateCode()
    {
        return $this->CorporateCode;
    }
    /**
     * Set CorporateCode value
     * @param string $corporateCode
     * @return \StructType\SendTaxFreeInvoiceData
     */
    public function setCorporateCode($corporateCode = null)
    {
        // validation for constraint: string
        if (!is_null($corporateCode) && !is_string($corporateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporateCode, true), gettype($corporateCode)), __LINE__);
        }
        $this->CorporateCode = $corporateCode;
        return $this;
    }
    /**
     * Get TemplateCode value
     * @return string|null
     */
    public function getTemplateCode()
    {
        return $this->TemplateCode;
    }
    /**
     * Set TemplateCode value
     * @param string $templateCode
     * @return \StructType\SendTaxFreeInvoiceData
     */
    public function setTemplateCode($templateCode = null)
    {
        // validation for constraint: string
        if (!is_null($templateCode) && !is_string($templateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateCode, true), gettype($templateCode)), __LINE__);
        }
        $this->TemplateCode = $templateCode;
        return $this;
    }
}
