<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartnerUsingCountsResults StructType
 * @subpackage Structs
 */
class PartnerUsingCountsResults extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * The OutgoingInvoiceUsingCounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOutgoingInvoiceCount
     */
    public $OutgoingInvoiceUsingCounts;
    /**
     * The IncomingInvoiceUsingCounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIncomingInvoiceCount
     */
    public $IncomingInvoiceUsingCounts;
    /**
     * The EarchiveInvoiceUsingCounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEarchiveInvoiceCount
     */
    public $EarchiveInvoiceUsingCounts;
    /**
     * The OutgoingDespatchAdviceCounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOutgoingDespatchAdviceCount
     */
    public $OutgoingDespatchAdviceCounts;
    /**
     * The IncomingDespatchAdviceCounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIncomingDespatchAdviceCount
     */
    public $IncomingDespatchAdviceCounts;
    /**
     * The ProducersSevoucherCounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProducersSevoucherCount
     */
    public $ProducersSevoucherCounts;
    /**
     * The ProducersReceiptCounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProducersReceiptCount
     */
    public $ProducersReceiptCounts;
    /**
     * Constructor method for PartnerUsingCountsResults
     * @uses PartnerUsingCountsResults::setServiceResult()
     * @uses PartnerUsingCountsResults::setErrorCode()
     * @uses PartnerUsingCountsResults::setServiceResultDescription()
     * @uses PartnerUsingCountsResults::setOutgoingInvoiceUsingCounts()
     * @uses PartnerUsingCountsResults::setIncomingInvoiceUsingCounts()
     * @uses PartnerUsingCountsResults::setEarchiveInvoiceUsingCounts()
     * @uses PartnerUsingCountsResults::setOutgoingDespatchAdviceCounts()
     * @uses PartnerUsingCountsResults::setIncomingDespatchAdviceCounts()
     * @uses PartnerUsingCountsResults::setProducersSevoucherCounts()
     * @uses PartnerUsingCountsResults::setProducersReceiptCounts()
     * @param string $serviceResult
     * @param int $errorCode
     * @param string $serviceResultDescription
     * @param \ArrayType\ArrayOfOutgoingInvoiceCount $outgoingInvoiceUsingCounts
     * @param \ArrayType\ArrayOfIncomingInvoiceCount $incomingInvoiceUsingCounts
     * @param \ArrayType\ArrayOfEarchiveInvoiceCount $earchiveInvoiceUsingCounts
     * @param \ArrayType\ArrayOfOutgoingDespatchAdviceCount $outgoingDespatchAdviceCounts
     * @param \ArrayType\ArrayOfIncomingDespatchAdviceCount $incomingDespatchAdviceCounts
     * @param \ArrayType\ArrayOfProducersSevoucherCount $producersSevoucherCounts
     * @param \ArrayType\ArrayOfProducersReceiptCount $producersReceiptCounts
     */
    public function __construct($serviceResult = null, $errorCode = null, $serviceResultDescription = null, \ArrayType\ArrayOfOutgoingInvoiceCount $outgoingInvoiceUsingCounts = null, \ArrayType\ArrayOfIncomingInvoiceCount $incomingInvoiceUsingCounts = null, \ArrayType\ArrayOfEarchiveInvoiceCount $earchiveInvoiceUsingCounts = null, \ArrayType\ArrayOfOutgoingDespatchAdviceCount $outgoingDespatchAdviceCounts = null, \ArrayType\ArrayOfIncomingDespatchAdviceCount $incomingDespatchAdviceCounts = null, \ArrayType\ArrayOfProducersSevoucherCount $producersSevoucherCounts = null, \ArrayType\ArrayOfProducersReceiptCount $producersReceiptCounts = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setErrorCode($errorCode)
            ->setServiceResultDescription($serviceResultDescription)
            ->setOutgoingInvoiceUsingCounts($outgoingInvoiceUsingCounts)
            ->setIncomingInvoiceUsingCounts($incomingInvoiceUsingCounts)
            ->setEarchiveInvoiceUsingCounts($earchiveInvoiceUsingCounts)
            ->setOutgoingDespatchAdviceCounts($outgoingDespatchAdviceCounts)
            ->setIncomingDespatchAdviceCounts($incomingDespatchAdviceCounts)
            ->setProducersSevoucherCounts($producersSevoucherCounts)
            ->setProducersReceiptCounts($producersReceiptCounts);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\PartnerUsingCountsResults
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\PartnerUsingCountsResults
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\PartnerUsingCountsResults
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
    /**
     * Get OutgoingInvoiceUsingCounts value
     * @return \ArrayType\ArrayOfOutgoingInvoiceCount|null
     */
    public function getOutgoingInvoiceUsingCounts()
    {
        return $this->OutgoingInvoiceUsingCounts;
    }
    /**
     * Set OutgoingInvoiceUsingCounts value
     * @param \ArrayType\ArrayOfOutgoingInvoiceCount $outgoingInvoiceUsingCounts
     * @return \StructType\PartnerUsingCountsResults
     */
    public function setOutgoingInvoiceUsingCounts(\ArrayType\ArrayOfOutgoingInvoiceCount $outgoingInvoiceUsingCounts = null)
    {
        $this->OutgoingInvoiceUsingCounts = $outgoingInvoiceUsingCounts;
        return $this;
    }
    /**
     * Get IncomingInvoiceUsingCounts value
     * @return \ArrayType\ArrayOfIncomingInvoiceCount|null
     */
    public function getIncomingInvoiceUsingCounts()
    {
        return $this->IncomingInvoiceUsingCounts;
    }
    /**
     * Set IncomingInvoiceUsingCounts value
     * @param \ArrayType\ArrayOfIncomingInvoiceCount $incomingInvoiceUsingCounts
     * @return \StructType\PartnerUsingCountsResults
     */
    public function setIncomingInvoiceUsingCounts(\ArrayType\ArrayOfIncomingInvoiceCount $incomingInvoiceUsingCounts = null)
    {
        $this->IncomingInvoiceUsingCounts = $incomingInvoiceUsingCounts;
        return $this;
    }
    /**
     * Get EarchiveInvoiceUsingCounts value
     * @return \ArrayType\ArrayOfEarchiveInvoiceCount|null
     */
    public function getEarchiveInvoiceUsingCounts()
    {
        return $this->EarchiveInvoiceUsingCounts;
    }
    /**
     * Set EarchiveInvoiceUsingCounts value
     * @param \ArrayType\ArrayOfEarchiveInvoiceCount $earchiveInvoiceUsingCounts
     * @return \StructType\PartnerUsingCountsResults
     */
    public function setEarchiveInvoiceUsingCounts(\ArrayType\ArrayOfEarchiveInvoiceCount $earchiveInvoiceUsingCounts = null)
    {
        $this->EarchiveInvoiceUsingCounts = $earchiveInvoiceUsingCounts;
        return $this;
    }
    /**
     * Get OutgoingDespatchAdviceCounts value
     * @return \ArrayType\ArrayOfOutgoingDespatchAdviceCount|null
     */
    public function getOutgoingDespatchAdviceCounts()
    {
        return $this->OutgoingDespatchAdviceCounts;
    }
    /**
     * Set OutgoingDespatchAdviceCounts value
     * @param \ArrayType\ArrayOfOutgoingDespatchAdviceCount $outgoingDespatchAdviceCounts
     * @return \StructType\PartnerUsingCountsResults
     */
    public function setOutgoingDespatchAdviceCounts(\ArrayType\ArrayOfOutgoingDespatchAdviceCount $outgoingDespatchAdviceCounts = null)
    {
        $this->OutgoingDespatchAdviceCounts = $outgoingDespatchAdviceCounts;
        return $this;
    }
    /**
     * Get IncomingDespatchAdviceCounts value
     * @return \ArrayType\ArrayOfIncomingDespatchAdviceCount|null
     */
    public function getIncomingDespatchAdviceCounts()
    {
        return $this->IncomingDespatchAdviceCounts;
    }
    /**
     * Set IncomingDespatchAdviceCounts value
     * @param \ArrayType\ArrayOfIncomingDespatchAdviceCount $incomingDespatchAdviceCounts
     * @return \StructType\PartnerUsingCountsResults
     */
    public function setIncomingDespatchAdviceCounts(\ArrayType\ArrayOfIncomingDespatchAdviceCount $incomingDespatchAdviceCounts = null)
    {
        $this->IncomingDespatchAdviceCounts = $incomingDespatchAdviceCounts;
        return $this;
    }
    /**
     * Get ProducersSevoucherCounts value
     * @return \ArrayType\ArrayOfProducersSevoucherCount|null
     */
    public function getProducersSevoucherCounts()
    {
        return $this->ProducersSevoucherCounts;
    }
    /**
     * Set ProducersSevoucherCounts value
     * @param \ArrayType\ArrayOfProducersSevoucherCount $producersSevoucherCounts
     * @return \StructType\PartnerUsingCountsResults
     */
    public function setProducersSevoucherCounts(\ArrayType\ArrayOfProducersSevoucherCount $producersSevoucherCounts = null)
    {
        $this->ProducersSevoucherCounts = $producersSevoucherCounts;
        return $this;
    }
    /**
     * Get ProducersReceiptCounts value
     * @return \ArrayType\ArrayOfProducersReceiptCount|null
     */
    public function getProducersReceiptCounts()
    {
        return $this->ProducersReceiptCounts;
    }
    /**
     * Set ProducersReceiptCounts value
     * @param \ArrayType\ArrayOfProducersReceiptCount $producersReceiptCounts
     * @return \StructType\PartnerUsingCountsResults
     */
    public function setProducersReceiptCounts(\ArrayType\ArrayOfProducersReceiptCount $producersReceiptCounts = null)
    {
        $this->ProducersReceiptCounts = $producersReceiptCounts;
        return $this;
    }
}
