<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartnerAndCorporateContourInfo StructType
 * @subpackage Structs
 */
class PartnerAndCorporateContourInfo extends AbstractStructBase
{
    /**
     * The productName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $productName;
    /**
     * The ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ticket;
    /**
     * The partnerCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partnerCode;
    /**
     * The corporateCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $corporateCode;
    /**
     * Constructor method for PartnerAndCorporateContourInfo
     * @uses PartnerAndCorporateContourInfo::setProductName()
     * @uses PartnerAndCorporateContourInfo::setTicket()
     * @uses PartnerAndCorporateContourInfo::setPartnerCode()
     * @uses PartnerAndCorporateContourInfo::setCorporateCode()
     * @param string $productName
     * @param string $ticket
     * @param string $partnerCode
     * @param string $corporateCode
     */
    public function __construct($productName = null, $ticket = null, $partnerCode = null, $corporateCode = null)
    {
        $this
            ->setProductName($productName)
            ->setTicket($ticket)
            ->setPartnerCode($partnerCode)
            ->setCorporateCode($corporateCode);
    }
    /**
     * Get productName value
     * @return string
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @uses \EnumType\ProductName::valueIsValid()
     * @uses \EnumType\ProductName::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productName
     * @return \StructType\PartnerAndCorporateContourInfo
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductName::valueIsValid($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductName', is_array($productName) ? implode(', ', $productName) : var_export($productName, true), implode(', ', \EnumType\ProductName::getValidValues())), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->ticket;
    }
    /**
     * Set ticket value
     * @param string $ticket
     * @return \StructType\PartnerAndCorporateContourInfo
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->ticket = $ticket;
        return $this;
    }
    /**
     * Get partnerCode value
     * @return string|null
     */
    public function getPartnerCode()
    {
        return $this->partnerCode;
    }
    /**
     * Set partnerCode value
     * @param string $partnerCode
     * @return \StructType\PartnerAndCorporateContourInfo
     */
    public function setPartnerCode($partnerCode = null)
    {
        // validation for constraint: string
        if (!is_null($partnerCode) && !is_string($partnerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerCode, true), gettype($partnerCode)), __LINE__);
        }
        $this->partnerCode = $partnerCode;
        return $this;
    }
    /**
     * Get corporateCode value
     * @return string|null
     */
    public function getCorporateCode()
    {
        return $this->corporateCode;
    }
    /**
     * Set corporateCode value
     * @param string $corporateCode
     * @return \StructType\PartnerAndCorporateContourInfo
     */
    public function setCorporateCode($corporateCode = null)
    {
        // validation for constraint: string
        if (!is_null($corporateCode) && !is_string($corporateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporateCode, true), gettype($corporateCode)), __LINE__);
        }
        $this->corporateCode = $corporateCode;
        return $this;
    }
}
