<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutSidersSendEmail StructType
 * @subpackage Structs
 */
class OutSidersSendEmail extends AbstractStructBase
{
    /**
     * The ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ticket;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OutsiderMailMessage
     */
    public $message;
    /**
     * Constructor method for OutSidersSendEmail
     * @uses OutSidersSendEmail::setTicket()
     * @uses OutSidersSendEmail::setMessage()
     * @param string $ticket
     * @param \StructType\OutsiderMailMessage $message
     */
    public function __construct($ticket = null, \StructType\OutsiderMailMessage $message = null)
    {
        $this
            ->setTicket($ticket)
            ->setMessage($message);
    }
    /**
     * Get ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->ticket;
    }
    /**
     * Set ticket value
     * @param string $ticket
     * @return \StructType\OutSidersSendEmail
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->ticket = $ticket;
        return $this;
    }
    /**
     * Get message value
     * @return \StructType\OutsiderMailMessage|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param \StructType\OutsiderMailMessage $message
     * @return \StructType\OutSidersSendEmail
     */
    public function setMessage(\StructType\OutsiderMailMessage $message = null)
    {
        $this->message = $message;
        return $this;
    }
}
