<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LogServerStatus StructType
 * @subpackage Structs
 */
class LogServerStatus extends AbstractStructBase
{
    /**
     * The accessDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $accessDate;
    /**
     * The corpCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $corpCode;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The messageDescriptor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $messageDescriptor;
    /**
     * Constructor method for LogServerStatus
     * @uses LogServerStatus::setAccessDate()
     * @uses LogServerStatus::setCorpCode()
     * @uses LogServerStatus::setMessage()
     * @uses LogServerStatus::setMessageDescriptor()
     * @param string $accessDate
     * @param string $corpCode
     * @param string $message
     * @param string $messageDescriptor
     */
    public function __construct($accessDate = null, $corpCode = null, $message = null, $messageDescriptor = null)
    {
        $this
            ->setAccessDate($accessDate)
            ->setCorpCode($corpCode)
            ->setMessage($message)
            ->setMessageDescriptor($messageDescriptor);
    }
    /**
     * Get accessDate value
     * @return string
     */
    public function getAccessDate()
    {
        return $this->accessDate;
    }
    /**
     * Set accessDate value
     * @param string $accessDate
     * @return \StructType\LogServerStatus
     */
    public function setAccessDate($accessDate = null)
    {
        // validation for constraint: string
        if (!is_null($accessDate) && !is_string($accessDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessDate, true), gettype($accessDate)), __LINE__);
        }
        $this->accessDate = $accessDate;
        return $this;
    }
    /**
     * Get corpCode value
     * @return string|null
     */
    public function getCorpCode()
    {
        return $this->corpCode;
    }
    /**
     * Set corpCode value
     * @param string $corpCode
     * @return \StructType\LogServerStatus
     */
    public function setCorpCode($corpCode = null)
    {
        // validation for constraint: string
        if (!is_null($corpCode) && !is_string($corpCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corpCode, true), gettype($corpCode)), __LINE__);
        }
        $this->corpCode = $corpCode;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\LogServerStatus
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get messageDescriptor value
     * @return string|null
     */
    public function getMessageDescriptor()
    {
        return $this->messageDescriptor;
    }
    /**
     * Set messageDescriptor value
     * @param string $messageDescriptor
     * @return \StructType\LogServerStatus
     */
    public function setMessageDescriptor($messageDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($messageDescriptor) && !is_string($messageDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageDescriptor, true), gettype($messageDescriptor)), __LINE__);
        }
        $this->messageDescriptor = $messageDescriptor;
        return $this;
    }
}
