<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceCountResultWithDate StructType
 * @subpackage Structs
 */
class InvoiceCountResultWithDate extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The OutgoingInvoiceCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OutgoingInvoiceCount;
    /**
     * The IncomingInvoiceCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IncomingInvoiceCount;
    /**
     * The DraftInvoiceCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DraftInvoiceCount;
    /**
     * The EarchiveInvoiceCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EarchiveInvoiceCount;
    /**
     * The OutgoingInvoiceCountSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvoiceCountWithDate
     */
    public $OutgoingInvoiceCountSummary;
    /**
     * The IncomingInvoiceCountSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvoiceCountWithDate
     */
    public $IncomingInvoiceCountSummary;
    /**
     * The DraftInvoiceCountSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvoiceCountWithDate
     */
    public $DraftInvoiceCountSummary;
    /**
     * The EarchiveInvoiceCountSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvoiceCountWithDate
     */
    public $EarchiveInvoiceCountSummary;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * Constructor method for InvoiceCountResultWithDate
     * @uses InvoiceCountResultWithDate::setServiceResult()
     * @uses InvoiceCountResultWithDate::setErrorCode()
     * @uses InvoiceCountResultWithDate::setOutgoingInvoiceCount()
     * @uses InvoiceCountResultWithDate::setIncomingInvoiceCount()
     * @uses InvoiceCountResultWithDate::setDraftInvoiceCount()
     * @uses InvoiceCountResultWithDate::setEarchiveInvoiceCount()
     * @uses InvoiceCountResultWithDate::setOutgoingInvoiceCountSummary()
     * @uses InvoiceCountResultWithDate::setIncomingInvoiceCountSummary()
     * @uses InvoiceCountResultWithDate::setDraftInvoiceCountSummary()
     * @uses InvoiceCountResultWithDate::setEarchiveInvoiceCountSummary()
     * @uses InvoiceCountResultWithDate::setServiceResultDescription()
     * @param string $serviceResult
     * @param int $errorCode
     * @param int $outgoingInvoiceCount
     * @param int $incomingInvoiceCount
     * @param int $draftInvoiceCount
     * @param int $earchiveInvoiceCount
     * @param \ArrayType\ArrayOfInvoiceCountWithDate $outgoingInvoiceCountSummary
     * @param \ArrayType\ArrayOfInvoiceCountWithDate $incomingInvoiceCountSummary
     * @param \ArrayType\ArrayOfInvoiceCountWithDate $draftInvoiceCountSummary
     * @param \ArrayType\ArrayOfInvoiceCountWithDate $earchiveInvoiceCountSummary
     * @param string $serviceResultDescription
     */
    public function __construct($serviceResult = null, $errorCode = null, $outgoingInvoiceCount = null, $incomingInvoiceCount = null, $draftInvoiceCount = null, $earchiveInvoiceCount = null, \ArrayType\ArrayOfInvoiceCountWithDate $outgoingInvoiceCountSummary = null, \ArrayType\ArrayOfInvoiceCountWithDate $incomingInvoiceCountSummary = null, \ArrayType\ArrayOfInvoiceCountWithDate $draftInvoiceCountSummary = null, \ArrayType\ArrayOfInvoiceCountWithDate $earchiveInvoiceCountSummary = null, $serviceResultDescription = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setErrorCode($errorCode)
            ->setOutgoingInvoiceCount($outgoingInvoiceCount)
            ->setIncomingInvoiceCount($incomingInvoiceCount)
            ->setDraftInvoiceCount($draftInvoiceCount)
            ->setEarchiveInvoiceCount($earchiveInvoiceCount)
            ->setOutgoingInvoiceCountSummary($outgoingInvoiceCountSummary)
            ->setIncomingInvoiceCountSummary($incomingInvoiceCountSummary)
            ->setDraftInvoiceCountSummary($draftInvoiceCountSummary)
            ->setEarchiveInvoiceCountSummary($earchiveInvoiceCountSummary)
            ->setServiceResultDescription($serviceResultDescription);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\InvoiceCountResultWithDate
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\InvoiceCountResultWithDate
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get OutgoingInvoiceCount value
     * @return int
     */
    public function getOutgoingInvoiceCount()
    {
        return $this->OutgoingInvoiceCount;
    }
    /**
     * Set OutgoingInvoiceCount value
     * @param int $outgoingInvoiceCount
     * @return \StructType\InvoiceCountResultWithDate
     */
    public function setOutgoingInvoiceCount($outgoingInvoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($outgoingInvoiceCount) && !(is_int($outgoingInvoiceCount) || ctype_digit($outgoingInvoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($outgoingInvoiceCount, true), gettype($outgoingInvoiceCount)), __LINE__);
        }
        $this->OutgoingInvoiceCount = $outgoingInvoiceCount;
        return $this;
    }
    /**
     * Get IncomingInvoiceCount value
     * @return int
     */
    public function getIncomingInvoiceCount()
    {
        return $this->IncomingInvoiceCount;
    }
    /**
     * Set IncomingInvoiceCount value
     * @param int $incomingInvoiceCount
     * @return \StructType\InvoiceCountResultWithDate
     */
    public function setIncomingInvoiceCount($incomingInvoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($incomingInvoiceCount) && !(is_int($incomingInvoiceCount) || ctype_digit($incomingInvoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($incomingInvoiceCount, true), gettype($incomingInvoiceCount)), __LINE__);
        }
        $this->IncomingInvoiceCount = $incomingInvoiceCount;
        return $this;
    }
    /**
     * Get DraftInvoiceCount value
     * @return int
     */
    public function getDraftInvoiceCount()
    {
        return $this->DraftInvoiceCount;
    }
    /**
     * Set DraftInvoiceCount value
     * @param int $draftInvoiceCount
     * @return \StructType\InvoiceCountResultWithDate
     */
    public function setDraftInvoiceCount($draftInvoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($draftInvoiceCount) && !(is_int($draftInvoiceCount) || ctype_digit($draftInvoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($draftInvoiceCount, true), gettype($draftInvoiceCount)), __LINE__);
        }
        $this->DraftInvoiceCount = $draftInvoiceCount;
        return $this;
    }
    /**
     * Get EarchiveInvoiceCount value
     * @return int
     */
    public function getEarchiveInvoiceCount()
    {
        return $this->EarchiveInvoiceCount;
    }
    /**
     * Set EarchiveInvoiceCount value
     * @param int $earchiveInvoiceCount
     * @return \StructType\InvoiceCountResultWithDate
     */
    public function setEarchiveInvoiceCount($earchiveInvoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($earchiveInvoiceCount) && !(is_int($earchiveInvoiceCount) || ctype_digit($earchiveInvoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($earchiveInvoiceCount, true), gettype($earchiveInvoiceCount)), __LINE__);
        }
        $this->EarchiveInvoiceCount = $earchiveInvoiceCount;
        return $this;
    }
    /**
     * Get OutgoingInvoiceCountSummary value
     * @return \ArrayType\ArrayOfInvoiceCountWithDate|null
     */
    public function getOutgoingInvoiceCountSummary()
    {
        return $this->OutgoingInvoiceCountSummary;
    }
    /**
     * Set OutgoingInvoiceCountSummary value
     * @param \ArrayType\ArrayOfInvoiceCountWithDate $outgoingInvoiceCountSummary
     * @return \StructType\InvoiceCountResultWithDate
     */
    public function setOutgoingInvoiceCountSummary(\ArrayType\ArrayOfInvoiceCountWithDate $outgoingInvoiceCountSummary = null)
    {
        $this->OutgoingInvoiceCountSummary = $outgoingInvoiceCountSummary;
        return $this;
    }
    /**
     * Get IncomingInvoiceCountSummary value
     * @return \ArrayType\ArrayOfInvoiceCountWithDate|null
     */
    public function getIncomingInvoiceCountSummary()
    {
        return $this->IncomingInvoiceCountSummary;
    }
    /**
     * Set IncomingInvoiceCountSummary value
     * @param \ArrayType\ArrayOfInvoiceCountWithDate $incomingInvoiceCountSummary
     * @return \StructType\InvoiceCountResultWithDate
     */
    public function setIncomingInvoiceCountSummary(\ArrayType\ArrayOfInvoiceCountWithDate $incomingInvoiceCountSummary = null)
    {
        $this->IncomingInvoiceCountSummary = $incomingInvoiceCountSummary;
        return $this;
    }
    /**
     * Get DraftInvoiceCountSummary value
     * @return \ArrayType\ArrayOfInvoiceCountWithDate|null
     */
    public function getDraftInvoiceCountSummary()
    {
        return $this->DraftInvoiceCountSummary;
    }
    /**
     * Set DraftInvoiceCountSummary value
     * @param \ArrayType\ArrayOfInvoiceCountWithDate $draftInvoiceCountSummary
     * @return \StructType\InvoiceCountResultWithDate
     */
    public function setDraftInvoiceCountSummary(\ArrayType\ArrayOfInvoiceCountWithDate $draftInvoiceCountSummary = null)
    {
        $this->DraftInvoiceCountSummary = $draftInvoiceCountSummary;
        return $this;
    }
    /**
     * Get EarchiveInvoiceCountSummary value
     * @return \ArrayType\ArrayOfInvoiceCountWithDate|null
     */
    public function getEarchiveInvoiceCountSummary()
    {
        return $this->EarchiveInvoiceCountSummary;
    }
    /**
     * Set EarchiveInvoiceCountSummary value
     * @param \ArrayType\ArrayOfInvoiceCountWithDate $earchiveInvoiceCountSummary
     * @return \StructType\InvoiceCountResultWithDate
     */
    public function setEarchiveInvoiceCountSummary(\ArrayType\ArrayOfInvoiceCountWithDate $earchiveInvoiceCountSummary = null)
    {
        $this->EarchiveInvoiceCountSummary = $earchiveInvoiceCountSummary;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\InvoiceCountResultWithDate
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
}
