<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInvoiceByInvoiceID StructType
 * @subpackage Structs
 */
class GetInvoiceByInvoiceID extends AbstractStructBase
{
    /**
     * The Direction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Direction;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The InvoiceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceID;
    /**
     * Constructor method for GetInvoiceByInvoiceID
     * @uses GetInvoiceByInvoiceID::setDirection()
     * @uses GetInvoiceByInvoiceID::setTicket()
     * @uses GetInvoiceByInvoiceID::setInvoiceID()
     * @param string $direction
     * @param string $ticket
     * @param string $invoiceID
     */
    public function __construct($direction = null, $ticket = null, $invoiceID = null)
    {
        $this
            ->setDirection($direction)
            ->setTicket($ticket)
            ->setInvoiceID($invoiceID);
    }
    /**
     * Get Direction value
     * @return string
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @uses \EnumType\Direction::valueIsValid()
     * @uses \EnumType\Direction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \StructType\GetInvoiceByInvoiceID
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Direction::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Direction', is_array($direction) ? implode(', ', $direction) : var_export($direction, true), implode(', ', \EnumType\Direction::getValidValues())), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\GetInvoiceByInvoiceID
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get InvoiceID value
     * @return string|null
     */
    public function getInvoiceID()
    {
        return $this->InvoiceID;
    }
    /**
     * Set InvoiceID value
     * @param string $invoiceID
     * @return \StructType\GetInvoiceByInvoiceID
     */
    public function setInvoiceID($invoiceID = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceID) && !is_string($invoiceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceID, true), gettype($invoiceID)), __LINE__);
        }
        $this->InvoiceID = $invoiceID;
        return $this;
    }
}
