<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInboundInvoiceByMapCode StructType
 * @subpackage Structs
 */
class GetInboundInvoiceByMapCode extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The MapCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MapCode;
    /**
     * Constructor method for GetInboundInvoiceByMapCode
     * @uses GetInboundInvoiceByMapCode::setTicket()
     * @uses GetInboundInvoiceByMapCode::setUUID()
     * @uses GetInboundInvoiceByMapCode::setMapCode()
     * @param string $ticket
     * @param string $uUID
     * @param string $mapCode
     */
    public function __construct($ticket = null, $uUID = null, $mapCode = null)
    {
        $this
            ->setTicket($ticket)
            ->setUUID($uUID)
            ->setMapCode($mapCode);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\GetInboundInvoiceByMapCode
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\GetInboundInvoiceByMapCode
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get MapCode value
     * @return string|null
     */
    public function getMapCode()
    {
        return $this->MapCode;
    }
    /**
     * Set MapCode value
     * @param string $mapCode
     * @return \StructType\GetInboundInvoiceByMapCode
     */
    public function setMapCode($mapCode = null)
    {
        // validation for constraint: string
        if (!is_null($mapCode) && !is_string($mapCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mapCode, true), gettype($mapCode)), __LINE__);
        }
        $this->MapCode = $mapCode;
        return $this;
    }
}
