<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHashOfInvoiceResult StructType
 * @subpackage Structs
 */
class GetHashOfInvoiceResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The InvoiceDirection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InvoiceDirection;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The HashCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HashCode;
    /**
     * Constructor method for GetHashOfInvoiceResult
     * @uses GetHashOfInvoiceResult::setServiceResult()
     * @uses GetHashOfInvoiceResult::setErrorCode()
     * @uses GetHashOfInvoiceResult::setInvoiceDirection()
     * @uses GetHashOfInvoiceResult::setServiceResultDescription()
     * @uses GetHashOfInvoiceResult::setUUID()
     * @uses GetHashOfInvoiceResult::setHashCode()
     * @param string $serviceResult
     * @param int $errorCode
     * @param string $invoiceDirection
     * @param string $serviceResultDescription
     * @param string $uUID
     * @param string $hashCode
     */
    public function __construct($serviceResult = null, $errorCode = null, $invoiceDirection = null, $serviceResultDescription = null, $uUID = null, $hashCode = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setErrorCode($errorCode)
            ->setInvoiceDirection($invoiceDirection)
            ->setServiceResultDescription($serviceResultDescription)
            ->setUUID($uUID)
            ->setHashCode($hashCode);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\GetHashOfInvoiceResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\GetHashOfInvoiceResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get InvoiceDirection value
     * @return string
     */
    public function getInvoiceDirection()
    {
        return $this->InvoiceDirection;
    }
    /**
     * Set InvoiceDirection value
     * @uses \EnumType\Direction::valueIsValid()
     * @uses \EnumType\Direction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $invoiceDirection
     * @return \StructType\GetHashOfInvoiceResult
     */
    public function setInvoiceDirection($invoiceDirection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Direction::valueIsValid($invoiceDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Direction', is_array($invoiceDirection) ? implode(', ', $invoiceDirection) : var_export($invoiceDirection, true), implode(', ', \EnumType\Direction::getValidValues())), __LINE__);
        }
        $this->InvoiceDirection = $invoiceDirection;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\GetHashOfInvoiceResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\GetHashOfInvoiceResult
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get HashCode value
     * @return string|null
     */
    public function getHashCode()
    {
        return $this->HashCode;
    }
    /**
     * Set HashCode value
     * @param string $hashCode
     * @return \StructType\GetHashOfInvoiceResult
     */
    public function setHashCode($hashCode = null)
    {
        // validation for constraint: string
        if (!is_null($hashCode) && !is_string($hashCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hashCode, true), gettype($hashCode)), __LINE__);
        }
        $this->HashCode = $hashCode;
        return $this;
    }
}
