<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFormsAuthenticationTicketPW StructType
 * @subpackage Structs
 */
class GetFormsAuthenticationTicketPW extends AbstractStructBase
{
    /**
     * The ErpCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErpCode;
    /**
     * The LoginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for GetFormsAuthenticationTicketPW
     * @uses GetFormsAuthenticationTicketPW::setErpCode()
     * @uses GetFormsAuthenticationTicketPW::setLoginName()
     * @uses GetFormsAuthenticationTicketPW::setPassword()
     * @param string $erpCode
     * @param string $loginName
     * @param string $password
     */
    public function __construct($erpCode = null, $loginName = null, $password = null)
    {
        $this
            ->setErpCode($erpCode)
            ->setLoginName($loginName)
            ->setPassword($password);
    }
    /**
     * Get ErpCode value
     * @return string|null
     */
    public function getErpCode()
    {
        return $this->ErpCode;
    }
    /**
     * Set ErpCode value
     * @param string $erpCode
     * @return \StructType\GetFormsAuthenticationTicketPW
     */
    public function setErpCode($erpCode = null)
    {
        // validation for constraint: string
        if (!is_null($erpCode) && !is_string($erpCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erpCode, true), gettype($erpCode)), __LINE__);
        }
        $this->ErpCode = $erpCode;
        return $this;
    }
    /**
     * Get LoginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->LoginName;
    }
    /**
     * Set LoginName value
     * @param string $loginName
     * @return \StructType\GetFormsAuthenticationTicketPW
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        $this->LoginName = $loginName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\GetFormsAuthenticationTicketPW
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
}
