<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEnvelope StructType
 * @subpackage Structs
 */
class GetEnvelope extends AbstractStructBase
{
    /**
     * The EnvelopeDownloadDocumentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EnvelopeDownloadDocumentType;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The ReferenceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceId;
    /**
     * Constructor method for GetEnvelope
     * @uses GetEnvelope::setEnvelopeDownloadDocumentType()
     * @uses GetEnvelope::setTicket()
     * @uses GetEnvelope::setReferenceId()
     * @param string $envelopeDownloadDocumentType
     * @param string $ticket
     * @param string $referenceId
     */
    public function __construct($envelopeDownloadDocumentType = null, $ticket = null, $referenceId = null)
    {
        $this
            ->setEnvelopeDownloadDocumentType($envelopeDownloadDocumentType)
            ->setTicket($ticket)
            ->setReferenceId($referenceId);
    }
    /**
     * Get EnvelopeDownloadDocumentType value
     * @return string
     */
    public function getEnvelopeDownloadDocumentType()
    {
        return $this->EnvelopeDownloadDocumentType;
    }
    /**
     * Set EnvelopeDownloadDocumentType value
     * @uses \EnumType\EnvelopeDownloadDocumentType::valueIsValid()
     * @uses \EnumType\EnvelopeDownloadDocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $envelopeDownloadDocumentType
     * @return \StructType\GetEnvelope
     */
    public function setEnvelopeDownloadDocumentType($envelopeDownloadDocumentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnvelopeDownloadDocumentType::valueIsValid($envelopeDownloadDocumentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnvelopeDownloadDocumentType', is_array($envelopeDownloadDocumentType) ? implode(', ', $envelopeDownloadDocumentType) : var_export($envelopeDownloadDocumentType, true), implode(', ', \EnumType\EnvelopeDownloadDocumentType::getValidValues())), __LINE__);
        }
        $this->EnvelopeDownloadDocumentType = $envelopeDownloadDocumentType;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\GetEnvelope
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get ReferenceId value
     * @return string|null
     */
    public function getReferenceId()
    {
        return $this->ReferenceId;
    }
    /**
     * Set ReferenceId value
     * @param string $referenceId
     * @return \StructType\GetEnvelope
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        $this->ReferenceId = $referenceId;
        return $this;
    }
}
