<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEArchiveReport StructType
 * @subpackage Structs
 */
class GetEArchiveReport extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The ReportNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReportNo;
    /**
     * The FileType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileType;
    /**
     * Constructor method for GetEArchiveReport
     * @uses GetEArchiveReport::setTicket()
     * @uses GetEArchiveReport::setReportNo()
     * @uses GetEArchiveReport::setFileType()
     * @param string $ticket
     * @param string $reportNo
     * @param string $fileType
     */
    public function __construct($ticket = null, $reportNo = null, $fileType = null)
    {
        $this
            ->setTicket($ticket)
            ->setReportNo($reportNo)
            ->setFileType($fileType);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\GetEArchiveReport
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get ReportNo value
     * @return string|null
     */
    public function getReportNo()
    {
        return $this->ReportNo;
    }
    /**
     * Set ReportNo value
     * @param string $reportNo
     * @return \StructType\GetEArchiveReport
     */
    public function setReportNo($reportNo = null)
    {
        // validation for constraint: string
        if (!is_null($reportNo) && !is_string($reportNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportNo, true), gettype($reportNo)), __LINE__);
        }
        $this->ReportNo = $reportNo;
        return $this;
    }
    /**
     * Get FileType value
     * @return string|null
     */
    public function getFileType()
    {
        return $this->FileType;
    }
    /**
     * Set FileType value
     * @param string $fileType
     * @return \StructType\GetEArchiveReport
     */
    public function setFileType($fileType = null)
    {
        // validation for constraint: string
        if (!is_null($fileType) && !is_string($fileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileType, true), gettype($fileType)), __LINE__);
        }
        $this->FileType = $fileType;
        return $this;
    }
}
