<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GTBRefAndRegNoResult StructType
 * @subpackage Structs
 */
class GTBRefAndRegNoResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The ExportDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExportDate;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceId;
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponseCode;
    /**
     * The ResponseDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponseDescription;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The RegistrationNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegistrationNumber;
    /**
     * Constructor method for GTBRefAndRegNoResult
     * @uses GTBRefAndRegNoResult::setServiceResult()
     * @uses GTBRefAndRegNoResult::setExportDate()
     * @uses GTBRefAndRegNoResult::setServiceResultDescription()
     * @uses GTBRefAndRegNoResult::setUUID()
     * @uses GTBRefAndRegNoResult::setInvoiceId()
     * @uses GTBRefAndRegNoResult::setResponseCode()
     * @uses GTBRefAndRegNoResult::setResponseDescription()
     * @uses GTBRefAndRegNoResult::setReferenceNumber()
     * @uses GTBRefAndRegNoResult::setRegistrationNumber()
     * @param string $serviceResult
     * @param string $exportDate
     * @param string $serviceResultDescription
     * @param string $uUID
     * @param string $invoiceId
     * @param string $responseCode
     * @param string $responseDescription
     * @param string $referenceNumber
     * @param string $registrationNumber
     */
    public function __construct($serviceResult = null, $exportDate = null, $serviceResultDescription = null, $uUID = null, $invoiceId = null, $responseCode = null, $responseDescription = null, $referenceNumber = null, $registrationNumber = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setExportDate($exportDate)
            ->setServiceResultDescription($serviceResultDescription)
            ->setUUID($uUID)
            ->setInvoiceId($invoiceId)
            ->setResponseCode($responseCode)
            ->setResponseDescription($responseDescription)
            ->setReferenceNumber($referenceNumber)
            ->setRegistrationNumber($registrationNumber);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\GTBRefAndRegNoResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get ExportDate value
     * @return string
     */
    public function getExportDate()
    {
        return $this->ExportDate;
    }
    /**
     * Set ExportDate value
     * @param string $exportDate
     * @return \StructType\GTBRefAndRegNoResult
     */
    public function setExportDate($exportDate = null)
    {
        // validation for constraint: string
        if (!is_null($exportDate) && !is_string($exportDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportDate, true), gettype($exportDate)), __LINE__);
        }
        $this->ExportDate = $exportDate;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\GTBRefAndRegNoResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\GTBRefAndRegNoResult
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return \StructType\GTBRefAndRegNoResult
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get ResponseCode value
     * @return string|null
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \StructType\GTBRefAndRegNoResult
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get ResponseDescription value
     * @return string|null
     */
    public function getResponseDescription()
    {
        return $this->ResponseDescription;
    }
    /**
     * Set ResponseDescription value
     * @param string $responseDescription
     * @return \StructType\GTBRefAndRegNoResult
     */
    public function setResponseDescription($responseDescription = null)
    {
        // validation for constraint: string
        if (!is_null($responseDescription) && !is_string($responseDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseDescription, true), gettype($responseDescription)), __LINE__);
        }
        $this->ResponseDescription = $responseDescription;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \StructType\GTBRefAndRegNoResult
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get RegistrationNumber value
     * @return string|null
     */
    public function getRegistrationNumber()
    {
        return $this->RegistrationNumber;
    }
    /**
     * Set RegistrationNumber value
     * @param string $registrationNumber
     * @return \StructType\GTBRefAndRegNoResult
     */
    public function setRegistrationNumber($registrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($registrationNumber) && !is_string($registrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationNumber, true), gettype($registrationNumber)), __LINE__);
        }
        $this->RegistrationNumber = $registrationNumber;
        return $this;
    }
}
