<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EInvoiceCustomerListResult StructType
 * @subpackage Structs
 */
class EInvoiceCustomerListResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * The CustomerInfoList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEInvoiceCustomerResult
     */
    public $CustomerInfoList;
    /**
     * The CSVFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CSVFile;
    /**
     * Constructor method for EInvoiceCustomerListResult
     * @uses EInvoiceCustomerListResult::setServiceResult()
     * @uses EInvoiceCustomerListResult::setErrorCode()
     * @uses EInvoiceCustomerListResult::setServiceResultDescription()
     * @uses EInvoiceCustomerListResult::setCustomerInfoList()
     * @uses EInvoiceCustomerListResult::setCSVFile()
     * @param string $serviceResult
     * @param int $errorCode
     * @param string $serviceResultDescription
     * @param \ArrayType\ArrayOfEInvoiceCustomerResult $customerInfoList
     * @param string $cSVFile
     */
    public function __construct($serviceResult = null, $errorCode = null, $serviceResultDescription = null, \ArrayType\ArrayOfEInvoiceCustomerResult $customerInfoList = null, $cSVFile = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setErrorCode($errorCode)
            ->setServiceResultDescription($serviceResultDescription)
            ->setCustomerInfoList($customerInfoList)
            ->setCSVFile($cSVFile);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\EInvoiceCustomerListResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\EInvoiceCustomerListResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\EInvoiceCustomerListResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
    /**
     * Get CustomerInfoList value
     * @return \ArrayType\ArrayOfEInvoiceCustomerResult|null
     */
    public function getCustomerInfoList()
    {
        return $this->CustomerInfoList;
    }
    /**
     * Set CustomerInfoList value
     * @param \ArrayType\ArrayOfEInvoiceCustomerResult $customerInfoList
     * @return \StructType\EInvoiceCustomerListResult
     */
    public function setCustomerInfoList(\ArrayType\ArrayOfEInvoiceCustomerResult $customerInfoList = null)
    {
        $this->CustomerInfoList = $customerInfoList;
        return $this;
    }
    /**
     * Get CSVFile value
     * @return string|null
     */
    public function getCSVFile()
    {
        return $this->CSVFile;
    }
    /**
     * Set CSVFile value
     * @param string $cSVFile
     * @return \StructType\EInvoiceCustomerListResult
     */
    public function setCSVFile($cSVFile = null)
    {
        // validation for constraint: string
        if (!is_null($cSVFile) && !is_string($cSVFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cSVFile, true), gettype($cSVFile)), __LINE__);
        }
        $this->CSVFile = $cSVFile;
        return $this;
    }
}
