<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckGibStatus StructType
 * @subpackage Structs
 */
class CheckGibStatus extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The Guid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Guid;
    /**
     * The GuidType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GuidType;
    /**
     * Constructor method for CheckGibStatus
     * @uses CheckGibStatus::setTicket()
     * @uses CheckGibStatus::setGuid()
     * @uses CheckGibStatus::setGuidType()
     * @param string $ticket
     * @param string $guid
     * @param string $guidType
     */
    public function __construct($ticket = null, $guid = null, $guidType = null)
    {
        $this
            ->setTicket($ticket)
            ->setGuid($guid)
            ->setGuidType($guidType);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\CheckGibStatus
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get Guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->Guid;
    }
    /**
     * Set Guid value
     * @param string $guid
     * @return \StructType\CheckGibStatus
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guid, true), gettype($guid)), __LINE__);
        }
        $this->Guid = $guid;
        return $this;
    }
    /**
     * Get GuidType value
     * @return string|null
     */
    public function getGuidType()
    {
        return $this->GuidType;
    }
    /**
     * Set GuidType value
     * @param string $guidType
     * @return \StructType\CheckGibStatus
     */
    public function setGuidType($guidType = null)
    {
        // validation for constraint: string
        if (!is_null($guidType) && !is_string($guidType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidType, true), gettype($guidType)), __LINE__);
        }
        $this->GuidType = $guidType;
        return $this;
    }
}
