<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelInvoiceNumber StructType
 * @subpackage Structs
 */
class CancelInvoiceNumber extends AbstractStructBase
{
    /**
     * The Year
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Year;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The ReceiptBarcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptBarcode;
    /**
     * Constructor method for CancelInvoiceNumber
     * @uses CancelInvoiceNumber::setYear()
     * @uses CancelInvoiceNumber::setTicket()
     * @uses CancelInvoiceNumber::setReceiptBarcode()
     * @param int $year
     * @param string $ticket
     * @param string $receiptBarcode
     */
    public function __construct($year = null, $ticket = null, $receiptBarcode = null)
    {
        $this
            ->setYear($year)
            ->setTicket($ticket)
            ->setReceiptBarcode($receiptBarcode);
    }
    /**
     * Get Year value
     * @return int
     */
    public function getYear()
    {
        return $this->Year;
    }
    /**
     * Set Year value
     * @param int $year
     * @return \StructType\CancelInvoiceNumber
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !(is_int($year) || ctype_digit($year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        $this->Year = $year;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\CancelInvoiceNumber
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get ReceiptBarcode value
     * @return string|null
     */
    public function getReceiptBarcode()
    {
        return $this->ReceiptBarcode;
    }
    /**
     * Set ReceiptBarcode value
     * @param string $receiptBarcode
     * @return \StructType\CancelInvoiceNumber
     */
    public function setReceiptBarcode($receiptBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($receiptBarcode) && !is_string($receiptBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiptBarcode, true), gettype($receiptBarcode)), __LINE__);
        }
        $this->ReceiptBarcode = $receiptBarcode;
        return $this;
    }
}
