<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationResponseResult StructType
 * @subpackage Structs
 */
class ApplicationResponseResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusCode;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The DocumentReferenceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentReferenceId;
    /**
     * The InvoiceUUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceUUID;
    /**
     * The StatusMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusMessage;
    /**
     * The StatusDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusDescription;
    /**
     * Constructor method for ApplicationResponseResult
     * @uses ApplicationResponseResult::setServiceResult()
     * @uses ApplicationResponseResult::setStatusCode()
     * @uses ApplicationResponseResult::setErrorCode()
     * @uses ApplicationResponseResult::setServiceResultDescription()
     * @uses ApplicationResponseResult::setUUID()
     * @uses ApplicationResponseResult::setDocumentReferenceId()
     * @uses ApplicationResponseResult::setInvoiceUUID()
     * @uses ApplicationResponseResult::setStatusMessage()
     * @uses ApplicationResponseResult::setStatusDescription()
     * @param string $serviceResult
     * @param int $statusCode
     * @param int $errorCode
     * @param string $serviceResultDescription
     * @param string $uUID
     * @param string $documentReferenceId
     * @param string $invoiceUUID
     * @param string $statusMessage
     * @param string $statusDescription
     */
    public function __construct($serviceResult = null, $statusCode = null, $errorCode = null, $serviceResultDescription = null, $uUID = null, $documentReferenceId = null, $invoiceUUID = null, $statusMessage = null, $statusDescription = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setStatusCode($statusCode)
            ->setErrorCode($errorCode)
            ->setServiceResultDescription($serviceResultDescription)
            ->setUUID($uUID)
            ->setDocumentReferenceId($documentReferenceId)
            ->setInvoiceUUID($invoiceUUID)
            ->setStatusMessage($statusMessage)
            ->setStatusDescription($statusDescription);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\ApplicationResponseResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \StructType\ApplicationResponseResult
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\ApplicationResponseResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\ApplicationResponseResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\ApplicationResponseResult
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get DocumentReferenceId value
     * @return string|null
     */
    public function getDocumentReferenceId()
    {
        return $this->DocumentReferenceId;
    }
    /**
     * Set DocumentReferenceId value
     * @param string $documentReferenceId
     * @return \StructType\ApplicationResponseResult
     */
    public function setDocumentReferenceId($documentReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($documentReferenceId) && !is_string($documentReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentReferenceId, true), gettype($documentReferenceId)), __LINE__);
        }
        $this->DocumentReferenceId = $documentReferenceId;
        return $this;
    }
    /**
     * Get InvoiceUUID value
     * @return string|null
     */
    public function getInvoiceUUID()
    {
        return $this->InvoiceUUID;
    }
    /**
     * Set InvoiceUUID value
     * @param string $invoiceUUID
     * @return \StructType\ApplicationResponseResult
     */
    public function setInvoiceUUID($invoiceUUID = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceUUID) && !is_string($invoiceUUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceUUID, true), gettype($invoiceUUID)), __LINE__);
        }
        $this->InvoiceUUID = $invoiceUUID;
        return $this;
    }
    /**
     * Get StatusMessage value
     * @return string|null
     */
    public function getStatusMessage()
    {
        return $this->StatusMessage;
    }
    /**
     * Set StatusMessage value
     * @param string $statusMessage
     * @return \StructType\ApplicationResponseResult
     */
    public function setStatusMessage($statusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($statusMessage) && !is_string($statusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusMessage, true), gettype($statusMessage)), __LINE__);
        }
        $this->StatusMessage = $statusMessage;
        return $this;
    }
    /**
     * Get StatusDescription value
     * @return string|null
     */
    public function getStatusDescription()
    {
        return $this->StatusDescription;
    }
    /**
     * Set StatusDescription value
     * @param string $statusDescription
     * @return \StructType\ApplicationResponseResult
     */
    public function setStatusDescription($statusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($statusDescription) && !is_string($statusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDescription, true), gettype($statusDescription)), __LINE__);
        }
        $this->StatusDescription = $statusDescription;
        return $this;
    }
}
