<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process ServiceType
 * @subpackage Services
 */
class Process extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ProcessDataWithCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessDataWithCode $parameters
     * @return \StructType\ProcessDataWithCodeResponse|bool
     */
    public function ProcessDataWithCode(\StructType\ProcessDataWithCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessDataWithCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProcessDataWithCodeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
