<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for Direction EnumType
 * @subpackage Enumerations
 */
class Direction extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Incoming'
     * @return string 'Incoming'
     */
    const VALUE_INCOMING = 'Incoming';
    /**
     * Constant for value 'Outgoing'
     * @return string 'Outgoing'
     */
    const VALUE_OUTGOING = 'Outgoing';
    /**
     * Constant for value 'AllDirection'
     * @return string 'AllDirection'
     */
    const VALUE_ALL_DIRECTION = 'AllDirection';
    /**
     * Constant for value 'EArchive'
     * @return string 'EArchive'
     */
    const VALUE_EARCHIVE = 'EArchive';
    /**
     * Constant for value 'EDefter'
     * @return string 'EDefter'
     */
    const VALUE_EDEFTER = 'EDefter';
    /**
     * Constant for value 'ETicket'
     * @return string 'ETicket'
     */
    const VALUE_ETICKET = 'ETicket';
    /**
     * Constant for value 'Despatch'
     * @return string 'Despatch'
     */
    const VALUE_DESPATCH = 'Despatch';
    /**
     * Constant for value 'ReceiptAdvice'
     * @return string 'ReceiptAdvice'
     */
    const VALUE_RECEIPT_ADVICE = 'ReceiptAdvice';
    /**
     * Constant for value 'DespatchOutgoingForMailSender'
     * @return string 'DespatchOutgoingForMailSender'
     */
    const VALUE_DESPATCH_OUTGOING_FOR_MAIL_SENDER = 'DespatchOutgoingForMailSender';
    /**
     * Constant for value 'DespatchIncomingForMailSender'
     * @return string 'DespatchIncomingForMailSender'
     */
    const VALUE_DESPATCH_INCOMING_FOR_MAIL_SENDER = 'DespatchIncomingForMailSender';
    /**
     * Constant for value 'ReceiptAdviceOutgoingForMailSender'
     * @return string 'ReceiptAdviceOutgoingForMailSender'
     */
    const VALUE_RECEIPT_ADVICE_OUTGOING_FOR_MAIL_SENDER = 'ReceiptAdviceOutgoingForMailSender';
    /**
     * Constant for value 'ReceiptAdviceIncomingForMailSender'
     * @return string 'ReceiptAdviceIncomingForMailSender'
     */
    const VALUE_RECEIPT_ADVICE_INCOMING_FOR_MAIL_SENDER = 'ReceiptAdviceIncomingForMailSender';
    /**
     * Constant for value 'Receipt'
     * @return string 'Receipt'
     */
    const VALUE_RECEIPT = 'Receipt';
    /**
     * Constant for value 'ReceiptReport'
     * @return string 'ReceiptReport'
     */
    const VALUE_RECEIPT_REPORT = 'ReceiptReport';
    /**
     * Constant for value 'SeVoucher'
     * @return string 'SeVoucher'
     */
    const VALUE_SE_VOUCHER = 'SeVoucher';
    /**
     * Constant for value 'SeVoucherReport'
     * @return string 'SeVoucherReport'
     */
    const VALUE_SE_VOUCHER_REPORT = 'SeVoucherReport';
    /**
     * Return allowed values
     * @uses self::VALUE_INCOMING
     * @uses self::VALUE_OUTGOING
     * @uses self::VALUE_ALL_DIRECTION
     * @uses self::VALUE_EARCHIVE
     * @uses self::VALUE_EDEFTER
     * @uses self::VALUE_ETICKET
     * @uses self::VALUE_DESPATCH
     * @uses self::VALUE_RECEIPT_ADVICE
     * @uses self::VALUE_DESPATCH_OUTGOING_FOR_MAIL_SENDER
     * @uses self::VALUE_DESPATCH_INCOMING_FOR_MAIL_SENDER
     * @uses self::VALUE_RECEIPT_ADVICE_OUTGOING_FOR_MAIL_SENDER
     * @uses self::VALUE_RECEIPT_ADVICE_INCOMING_FOR_MAIL_SENDER
     * @uses self::VALUE_RECEIPT
     * @uses self::VALUE_RECEIPT_REPORT
     * @uses self::VALUE_SE_VOUCHER
     * @uses self::VALUE_SE_VOUCHER_REPORT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INCOMING,
            self::VALUE_OUTGOING,
            self::VALUE_ALL_DIRECTION,
            self::VALUE_EARCHIVE,
            self::VALUE_EDEFTER,
            self::VALUE_ETICKET,
            self::VALUE_DESPATCH,
            self::VALUE_RECEIPT_ADVICE,
            self::VALUE_DESPATCH_OUTGOING_FOR_MAIL_SENDER,
            self::VALUE_DESPATCH_INCOMING_FOR_MAIL_SENDER,
            self::VALUE_RECEIPT_ADVICE_OUTGOING_FOR_MAIL_SENDER,
            self::VALUE_RECEIPT_ADVICE_INCOMING_FOR_MAIL_SENDER,
            self::VALUE_RECEIPT,
            self::VALUE_RECEIPT_REPORT,
            self::VALUE_SE_VOUCHER,
            self::VALUE_SE_VOUCHER_REPORT,
        );
    }
}
