<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoiceInfoList ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoiceInfoList extends AbstractStructArrayBase
{
    /**
     * The InvoiceInfoList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceInfoList[]
     */
    public $InvoiceInfoList;
    /**
     * Constructor method for ArrayOfInvoiceInfoList
     * @uses ArrayOfInvoiceInfoList::setInvoiceInfoList()
     * @param \StructType\InvoiceInfoList[] $invoiceInfoList
     */
    public function __construct(array $invoiceInfoList = array())
    {
        $this
            ->setInvoiceInfoList($invoiceInfoList);
    }
    /**
     * Get InvoiceInfoList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceInfoList[]|null
     */
    public function getInvoiceInfoList()
    {
        return isset($this->InvoiceInfoList) ? $this->InvoiceInfoList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoiceInfoList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceInfoList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceInfoListForArrayConstraintsFromSetInvoiceInfoList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInvoiceInfoListInvoiceInfoListItem) {
            // validation for constraint: itemType
            if (!$arrayOfInvoiceInfoListInvoiceInfoListItem instanceof \StructType\InvoiceInfoList) {
                $invalidValues[] = is_object($arrayOfInvoiceInfoListInvoiceInfoListItem) ? get_class($arrayOfInvoiceInfoListInvoiceInfoListItem) : sprintf('%s(%s)', gettype($arrayOfInvoiceInfoListInvoiceInfoListItem), var_export($arrayOfInvoiceInfoListInvoiceInfoListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceInfoList property can only contain items of type \StructType\InvoiceInfoList, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoiceInfoList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceInfoList[] $invoiceInfoList
     * @return \ArrayType\ArrayOfInvoiceInfoList
     */
    public function setInvoiceInfoList(array $invoiceInfoList = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceInfoListArrayErrorMessage = self::validateInvoiceInfoListForArrayConstraintsFromSetInvoiceInfoList($invoiceInfoList))) {
            throw new \InvalidArgumentException($invoiceInfoListArrayErrorMessage, __LINE__);
        }
        if (is_null($invoiceInfoList) || (is_array($invoiceInfoList) && empty($invoiceInfoList))) {
            unset($this->InvoiceInfoList);
        } else {
            $this->InvoiceInfoList = $invoiceInfoList;
        }
        return $this;
    }
    /**
     * Add item to InvoiceInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceInfoList $item
     * @return \ArrayType\ArrayOfInvoiceInfoList
     */
    public function addToInvoiceInfoList(\StructType\InvoiceInfoList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceInfoList) {
            throw new \InvalidArgumentException(sprintf('The InvoiceInfoList property can only contain items of type \StructType\InvoiceInfoList, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceInfoList[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InvoiceInfoList|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InvoiceInfoList|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InvoiceInfoList|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InvoiceInfoList|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InvoiceInfoList|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoiceInfoList
     */
    public function getAttributeName()
    {
        return 'InvoiceInfoList';
    }
}
