<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadFromArchiveUBLOutgoing StructType
 * @subpackage Structs
 */
class UploadFromArchiveUBLOutgoing extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The InvoiceRawData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceRawData;
    /**
     * The CorporateCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorporateCode;
    /**
     * The ReceiverPostboxName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverPostboxName;
    /**
     * Constructor method for UploadFromArchiveUBLOutgoing
     * @uses UploadFromArchiveUBLOutgoing::setTicket()
     * @uses UploadFromArchiveUBLOutgoing::setInvoiceRawData()
     * @uses UploadFromArchiveUBLOutgoing::setCorporateCode()
     * @uses UploadFromArchiveUBLOutgoing::setReceiverPostboxName()
     * @param string $ticket
     * @param string $invoiceRawData
     * @param string $corporateCode
     * @param string $receiverPostboxName
     */
    public function __construct($ticket = null, $invoiceRawData = null, $corporateCode = null, $receiverPostboxName = null)
    {
        $this
            ->setTicket($ticket)
            ->setInvoiceRawData($invoiceRawData)
            ->setCorporateCode($corporateCode)
            ->setReceiverPostboxName($receiverPostboxName);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\UploadFromArchiveUBLOutgoing
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get InvoiceRawData value
     * @return string|null
     */
    public function getInvoiceRawData()
    {
        return $this->InvoiceRawData;
    }
    /**
     * Set InvoiceRawData value
     * @param string $invoiceRawData
     * @return \StructType\UploadFromArchiveUBLOutgoing
     */
    public function setInvoiceRawData($invoiceRawData = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceRawData) && !is_string($invoiceRawData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceRawData, true), gettype($invoiceRawData)), __LINE__);
        }
        $this->InvoiceRawData = $invoiceRawData;
        return $this;
    }
    /**
     * Get CorporateCode value
     * @return string|null
     */
    public function getCorporateCode()
    {
        return $this->CorporateCode;
    }
    /**
     * Set CorporateCode value
     * @param string $corporateCode
     * @return \StructType\UploadFromArchiveUBLOutgoing
     */
    public function setCorporateCode($corporateCode = null)
    {
        // validation for constraint: string
        if (!is_null($corporateCode) && !is_string($corporateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporateCode, true), gettype($corporateCode)), __LINE__);
        }
        $this->CorporateCode = $corporateCode;
        return $this;
    }
    /**
     * Get ReceiverPostboxName value
     * @return string|null
     */
    public function getReceiverPostboxName()
    {
        return $this->ReceiverPostboxName;
    }
    /**
     * Set ReceiverPostboxName value
     * @param string $receiverPostboxName
     * @return \StructType\UploadFromArchiveUBLOutgoing
     */
    public function setReceiverPostboxName($receiverPostboxName = null)
    {
        // validation for constraint: string
        if (!is_null($receiverPostboxName) && !is_string($receiverPostboxName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverPostboxName, true), gettype($receiverPostboxName)), __LINE__);
        }
        $this->ReceiverPostboxName = $receiverPostboxName;
        return $this;
    }
}
