<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServerStatusResult StructType
 * @subpackage Structs
 */
class ServerStatusResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorCode;
    /**
     * Constructor method for ServerStatusResult
     * @uses ServerStatusResult::setServiceResult()
     * @uses ServerStatusResult::setErrorCode()
     * @param string $serviceResult
     * @param string $errorCode
     */
    public function __construct($serviceResult = null, $errorCode = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setErrorCode($errorCode);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\ServerStatusResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \StructType\ServerStatusResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
}
