<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendBase64StringInvoice StructType
 * @subpackage Structs
 */
class SendBase64StringInvoice extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The FileType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileType;
    /**
     * The InvoiceRawData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceRawData;
    /**
     * The CorporateCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorporateCode;
    /**
     * The MapCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MapCode;
    /**
     * The ReceiverPostboxName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverPostboxName;
    /**
     * Constructor method for SendBase64StringInvoice
     * @uses SendBase64StringInvoice::setTicket()
     * @uses SendBase64StringInvoice::setFileType()
     * @uses SendBase64StringInvoice::setInvoiceRawData()
     * @uses SendBase64StringInvoice::setCorporateCode()
     * @uses SendBase64StringInvoice::setMapCode()
     * @uses SendBase64StringInvoice::setReceiverPostboxName()
     * @param string $ticket
     * @param string $fileType
     * @param string $invoiceRawData
     * @param string $corporateCode
     * @param string $mapCode
     * @param string $receiverPostboxName
     */
    public function __construct($ticket = null, $fileType = null, $invoiceRawData = null, $corporateCode = null, $mapCode = null, $receiverPostboxName = null)
    {
        $this
            ->setTicket($ticket)
            ->setFileType($fileType)
            ->setInvoiceRawData($invoiceRawData)
            ->setCorporateCode($corporateCode)
            ->setMapCode($mapCode)
            ->setReceiverPostboxName($receiverPostboxName);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\SendBase64StringInvoice
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get FileType value
     * @return string|null
     */
    public function getFileType()
    {
        return $this->FileType;
    }
    /**
     * Set FileType value
     * @param string $fileType
     * @return \StructType\SendBase64StringInvoice
     */
    public function setFileType($fileType = null)
    {
        // validation for constraint: string
        if (!is_null($fileType) && !is_string($fileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileType, true), gettype($fileType)), __LINE__);
        }
        $this->FileType = $fileType;
        return $this;
    }
    /**
     * Get InvoiceRawData value
     * @return string|null
     */
    public function getInvoiceRawData()
    {
        return $this->InvoiceRawData;
    }
    /**
     * Set InvoiceRawData value
     * @param string $invoiceRawData
     * @return \StructType\SendBase64StringInvoice
     */
    public function setInvoiceRawData($invoiceRawData = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceRawData) && !is_string($invoiceRawData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceRawData, true), gettype($invoiceRawData)), __LINE__);
        }
        $this->InvoiceRawData = $invoiceRawData;
        return $this;
    }
    /**
     * Get CorporateCode value
     * @return string|null
     */
    public function getCorporateCode()
    {
        return $this->CorporateCode;
    }
    /**
     * Set CorporateCode value
     * @param string $corporateCode
     * @return \StructType\SendBase64StringInvoice
     */
    public function setCorporateCode($corporateCode = null)
    {
        // validation for constraint: string
        if (!is_null($corporateCode) && !is_string($corporateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporateCode, true), gettype($corporateCode)), __LINE__);
        }
        $this->CorporateCode = $corporateCode;
        return $this;
    }
    /**
     * Get MapCode value
     * @return string|null
     */
    public function getMapCode()
    {
        return $this->MapCode;
    }
    /**
     * Set MapCode value
     * @param string $mapCode
     * @return \StructType\SendBase64StringInvoice
     */
    public function setMapCode($mapCode = null)
    {
        // validation for constraint: string
        if (!is_null($mapCode) && !is_string($mapCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mapCode, true), gettype($mapCode)), __LINE__);
        }
        $this->MapCode = $mapCode;
        return $this;
    }
    /**
     * Get ReceiverPostboxName value
     * @return string|null
     */
    public function getReceiverPostboxName()
    {
        return $this->ReceiverPostboxName;
    }
    /**
     * Set ReceiverPostboxName value
     * @param string $receiverPostboxName
     * @return \StructType\SendBase64StringInvoice
     */
    public function setReceiverPostboxName($receiverPostboxName = null)
    {
        // validation for constraint: string
        if (!is_null($receiverPostboxName) && !is_string($receiverPostboxName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverPostboxName, true), gettype($receiverPostboxName)), __LINE__);
        }
        $this->ReceiverPostboxName = $receiverPostboxName;
        return $this;
    }
}
