<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendApplicationResponse StructType
 * @subpackage Structs
 */
class SendApplicationResponse extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The CorporateCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorporateCode;
    /**
     * The ApplicationResponseData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationResponseData;
    /**
     * Constructor method for SendApplicationResponse
     * @uses SendApplicationResponse::setTicket()
     * @uses SendApplicationResponse::setUUID()
     * @uses SendApplicationResponse::setCorporateCode()
     * @uses SendApplicationResponse::setApplicationResponseData()
     * @param string $ticket
     * @param string $uUID
     * @param string $corporateCode
     * @param string $applicationResponseData
     */
    public function __construct($ticket = null, $uUID = null, $corporateCode = null, $applicationResponseData = null)
    {
        $this
            ->setTicket($ticket)
            ->setUUID($uUID)
            ->setCorporateCode($corporateCode)
            ->setApplicationResponseData($applicationResponseData);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\SendApplicationResponse
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\SendApplicationResponse
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get CorporateCode value
     * @return string|null
     */
    public function getCorporateCode()
    {
        return $this->CorporateCode;
    }
    /**
     * Set CorporateCode value
     * @param string $corporateCode
     * @return \StructType\SendApplicationResponse
     */
    public function setCorporateCode($corporateCode = null)
    {
        // validation for constraint: string
        if (!is_null($corporateCode) && !is_string($corporateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporateCode, true), gettype($corporateCode)), __LINE__);
        }
        $this->CorporateCode = $corporateCode;
        return $this;
    }
    /**
     * Get ApplicationResponseData value
     * @return string|null
     */
    public function getApplicationResponseData()
    {
        return $this->ApplicationResponseData;
    }
    /**
     * Set ApplicationResponseData value
     * @param string $applicationResponseData
     * @return \StructType\SendApplicationResponse
     */
    public function setApplicationResponseData($applicationResponseData = null)
    {
        // validation for constraint: string
        if (!is_null($applicationResponseData) && !is_string($applicationResponseData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationResponseData, true), gettype($applicationResponseData)), __LINE__);
        }
        $this->ApplicationResponseData = $applicationResponseData;
        return $this;
    }
}
