<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseResult StructType
 * @subpackage Structs
 */
class ResponseResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The AcceptOrRejectInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AcceptOrRejectInvoice;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * Constructor method for ResponseResult
     * @uses ResponseResult::setServiceResult()
     * @uses ResponseResult::setAcceptOrRejectInvoice()
     * @uses ResponseResult::setErrorCode()
     * @uses ResponseResult::setServiceResultDescription()
     * @param string $serviceResult
     * @param bool $acceptOrRejectInvoice
     * @param int $errorCode
     * @param string $serviceResultDescription
     */
    public function __construct($serviceResult = null, $acceptOrRejectInvoice = null, $errorCode = null, $serviceResultDescription = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setAcceptOrRejectInvoice($acceptOrRejectInvoice)
            ->setErrorCode($errorCode)
            ->setServiceResultDescription($serviceResultDescription);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\ResponseResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get AcceptOrRejectInvoice value
     * @return bool
     */
    public function getAcceptOrRejectInvoice()
    {
        return $this->AcceptOrRejectInvoice;
    }
    /**
     * Set AcceptOrRejectInvoice value
     * @param bool $acceptOrRejectInvoice
     * @return \StructType\ResponseResult
     */
    public function setAcceptOrRejectInvoice($acceptOrRejectInvoice = null)
    {
        // validation for constraint: boolean
        if (!is_null($acceptOrRejectInvoice) && !is_bool($acceptOrRejectInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($acceptOrRejectInvoice, true), gettype($acceptOrRejectInvoice)), __LINE__);
        }
        $this->AcceptOrRejectInvoice = $acceptOrRejectInvoice;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\ResponseResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\ResponseResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
}
