<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceInfoResult StructType
 * @subpackage Structs
 */
class InvoiceInfoResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusCode;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The Issuedate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Issuedate;
    /**
     * The Issuetime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Issuetime;
    /**
     * The AllowanceTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AllowanceTotalAmount;
    /**
     * The ChargeTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ChargeTotalAmount;
    /**
     * The TaxTotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxTotalAmount;
    /**
     * The PaymentDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PaymentDueDate;
    /**
     * The SendingType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SendingType;
    /**
     * The PaymentMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentMeans;
    /**
     * The Createdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Createdate;
    /**
     * The Direction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Direction;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvoiceOption
     */
    public $Options;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceId;
    /**
     * The ReturnValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnValue;
    /**
     * The StatusDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusDescription;
    /**
     * The Invoicetypecode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoicetypecode;
    /**
     * The Sendertaxid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sendertaxid;
    /**
     * The Receivertaxid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receivertaxid;
    /**
     * The Profileid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Profileid;
    /**
     * The Payableamount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Payableamount;
    /**
     * The Partyname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Partyname;
    /**
     * The ReceiverPostBoxName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverPostBoxName;
    /**
     * The SenderPostBoxName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderPostBoxName;
    /**
     * The DocumentCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentCurrency;
    /**
     * The OrderReferenceNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderReferenceNo;
    /**
     * The ReferenceNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNo;
    /**
     * The BranchNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchNo;
    /**
     * The BranchName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchName;
    /**
     * Constructor method for InvoiceInfoResult
     * @uses InvoiceInfoResult::setServiceResult()
     * @uses InvoiceInfoResult::setStatusCode()
     * @uses InvoiceInfoResult::setErrorCode()
     * @uses InvoiceInfoResult::setIssuedate()
     * @uses InvoiceInfoResult::setIssuetime()
     * @uses InvoiceInfoResult::setAllowanceTotalAmount()
     * @uses InvoiceInfoResult::setChargeTotalAmount()
     * @uses InvoiceInfoResult::setTaxTotalAmount()
     * @uses InvoiceInfoResult::setPaymentDueDate()
     * @uses InvoiceInfoResult::setSendingType()
     * @uses InvoiceInfoResult::setPaymentMeans()
     * @uses InvoiceInfoResult::setCreatedate()
     * @uses InvoiceInfoResult::setDirection()
     * @uses InvoiceInfoResult::setOptions()
     * @uses InvoiceInfoResult::setServiceResultDescription()
     * @uses InvoiceInfoResult::setUUID()
     * @uses InvoiceInfoResult::setInvoiceId()
     * @uses InvoiceInfoResult::setReturnValue()
     * @uses InvoiceInfoResult::setStatusDescription()
     * @uses InvoiceInfoResult::setInvoicetypecode()
     * @uses InvoiceInfoResult::setSendertaxid()
     * @uses InvoiceInfoResult::setReceivertaxid()
     * @uses InvoiceInfoResult::setProfileid()
     * @uses InvoiceInfoResult::setPayableamount()
     * @uses InvoiceInfoResult::setPartyname()
     * @uses InvoiceInfoResult::setReceiverPostBoxName()
     * @uses InvoiceInfoResult::setSenderPostBoxName()
     * @uses InvoiceInfoResult::setDocumentCurrency()
     * @uses InvoiceInfoResult::setOrderReferenceNo()
     * @uses InvoiceInfoResult::setReferenceNo()
     * @uses InvoiceInfoResult::setBranchNo()
     * @uses InvoiceInfoResult::setBranchName()
     * @param string $serviceResult
     * @param int $statusCode
     * @param int $errorCode
     * @param string $issuedate
     * @param string $issuetime
     * @param float $allowanceTotalAmount
     * @param float $chargeTotalAmount
     * @param float $taxTotalAmount
     * @param string $paymentDueDate
     * @param int $sendingType
     * @param int $paymentMeans
     * @param string $createdate
     * @param string $direction
     * @param \ArrayType\ArrayOfInvoiceOption $options
     * @param string $serviceResultDescription
     * @param string $uUID
     * @param string $invoiceId
     * @param string $returnValue
     * @param string $statusDescription
     * @param string $invoicetypecode
     * @param string $sendertaxid
     * @param string $receivertaxid
     * @param string $profileid
     * @param string $payableamount
     * @param string $partyname
     * @param string $receiverPostBoxName
     * @param string $senderPostBoxName
     * @param string $documentCurrency
     * @param string $orderReferenceNo
     * @param string $referenceNo
     * @param string $branchNo
     * @param string $branchName
     */
    public function __construct($serviceResult = null, $statusCode = null, $errorCode = null, $issuedate = null, $issuetime = null, $allowanceTotalAmount = null, $chargeTotalAmount = null, $taxTotalAmount = null, $paymentDueDate = null, $sendingType = null, $paymentMeans = null, $createdate = null, $direction = null, \ArrayType\ArrayOfInvoiceOption $options = null, $serviceResultDescription = null, $uUID = null, $invoiceId = null, $returnValue = null, $statusDescription = null, $invoicetypecode = null, $sendertaxid = null, $receivertaxid = null, $profileid = null, $payableamount = null, $partyname = null, $receiverPostBoxName = null, $senderPostBoxName = null, $documentCurrency = null, $orderReferenceNo = null, $referenceNo = null, $branchNo = null, $branchName = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setStatusCode($statusCode)
            ->setErrorCode($errorCode)
            ->setIssuedate($issuedate)
            ->setIssuetime($issuetime)
            ->setAllowanceTotalAmount($allowanceTotalAmount)
            ->setChargeTotalAmount($chargeTotalAmount)
            ->setTaxTotalAmount($taxTotalAmount)
            ->setPaymentDueDate($paymentDueDate)
            ->setSendingType($sendingType)
            ->setPaymentMeans($paymentMeans)
            ->setCreatedate($createdate)
            ->setDirection($direction)
            ->setOptions($options)
            ->setServiceResultDescription($serviceResultDescription)
            ->setUUID($uUID)
            ->setInvoiceId($invoiceId)
            ->setReturnValue($returnValue)
            ->setStatusDescription($statusDescription)
            ->setInvoicetypecode($invoicetypecode)
            ->setSendertaxid($sendertaxid)
            ->setReceivertaxid($receivertaxid)
            ->setProfileid($profileid)
            ->setPayableamount($payableamount)
            ->setPartyname($partyname)
            ->setReceiverPostBoxName($receiverPostBoxName)
            ->setSenderPostBoxName($senderPostBoxName)
            ->setDocumentCurrency($documentCurrency)
            ->setOrderReferenceNo($orderReferenceNo)
            ->setReferenceNo($referenceNo)
            ->setBranchNo($branchNo)
            ->setBranchName($branchName);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\InvoiceInfoResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \StructType\InvoiceInfoResult
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\InvoiceInfoResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get Issuedate value
     * @return string
     */
    public function getIssuedate()
    {
        return $this->Issuedate;
    }
    /**
     * Set Issuedate value
     * @param string $issuedate
     * @return \StructType\InvoiceInfoResult
     */
    public function setIssuedate($issuedate = null)
    {
        // validation for constraint: string
        if (!is_null($issuedate) && !is_string($issuedate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuedate, true), gettype($issuedate)), __LINE__);
        }
        $this->Issuedate = $issuedate;
        return $this;
    }
    /**
     * Get Issuetime value
     * @return string
     */
    public function getIssuetime()
    {
        return $this->Issuetime;
    }
    /**
     * Set Issuetime value
     * @param string $issuetime
     * @return \StructType\InvoiceInfoResult
     */
    public function setIssuetime($issuetime = null)
    {
        // validation for constraint: string
        if (!is_null($issuetime) && !is_string($issuetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuetime, true), gettype($issuetime)), __LINE__);
        }
        $this->Issuetime = $issuetime;
        return $this;
    }
    /**
     * Get AllowanceTotalAmount value
     * @return float
     */
    public function getAllowanceTotalAmount()
    {
        return $this->AllowanceTotalAmount;
    }
    /**
     * Set AllowanceTotalAmount value
     * @param float $allowanceTotalAmount
     * @return \StructType\InvoiceInfoResult
     */
    public function setAllowanceTotalAmount($allowanceTotalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($allowanceTotalAmount) && !(is_float($allowanceTotalAmount) || is_numeric($allowanceTotalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($allowanceTotalAmount, true), gettype($allowanceTotalAmount)), __LINE__);
        }
        $this->AllowanceTotalAmount = $allowanceTotalAmount;
        return $this;
    }
    /**
     * Get ChargeTotalAmount value
     * @return float
     */
    public function getChargeTotalAmount()
    {
        return $this->ChargeTotalAmount;
    }
    /**
     * Set ChargeTotalAmount value
     * @param float $chargeTotalAmount
     * @return \StructType\InvoiceInfoResult
     */
    public function setChargeTotalAmount($chargeTotalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($chargeTotalAmount) && !(is_float($chargeTotalAmount) || is_numeric($chargeTotalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($chargeTotalAmount, true), gettype($chargeTotalAmount)), __LINE__);
        }
        $this->ChargeTotalAmount = $chargeTotalAmount;
        return $this;
    }
    /**
     * Get TaxTotalAmount value
     * @return float
     */
    public function getTaxTotalAmount()
    {
        return $this->TaxTotalAmount;
    }
    /**
     * Set TaxTotalAmount value
     * @param float $taxTotalAmount
     * @return \StructType\InvoiceInfoResult
     */
    public function setTaxTotalAmount($taxTotalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxTotalAmount) && !(is_float($taxTotalAmount) || is_numeric($taxTotalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxTotalAmount, true), gettype($taxTotalAmount)), __LINE__);
        }
        $this->TaxTotalAmount = $taxTotalAmount;
        return $this;
    }
    /**
     * Get PaymentDueDate value
     * @return string
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }
    /**
     * Set PaymentDueDate value
     * @param string $paymentDueDate
     * @return \StructType\InvoiceInfoResult
     */
    public function setPaymentDueDate($paymentDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDueDate) && !is_string($paymentDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDueDate, true), gettype($paymentDueDate)), __LINE__);
        }
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }
    /**
     * Get SendingType value
     * @return int
     */
    public function getSendingType()
    {
        return $this->SendingType;
    }
    /**
     * Set SendingType value
     * @param int $sendingType
     * @return \StructType\InvoiceInfoResult
     */
    public function setSendingType($sendingType = null)
    {
        // validation for constraint: int
        if (!is_null($sendingType) && !(is_int($sendingType) || ctype_digit($sendingType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sendingType, true), gettype($sendingType)), __LINE__);
        }
        $this->SendingType = $sendingType;
        return $this;
    }
    /**
     * Get PaymentMeans value
     * @return int
     */
    public function getPaymentMeans()
    {
        return $this->PaymentMeans;
    }
    /**
     * Set PaymentMeans value
     * @param int $paymentMeans
     * @return \StructType\InvoiceInfoResult
     */
    public function setPaymentMeans($paymentMeans = null)
    {
        // validation for constraint: int
        if (!is_null($paymentMeans) && !(is_int($paymentMeans) || ctype_digit($paymentMeans))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentMeans, true), gettype($paymentMeans)), __LINE__);
        }
        $this->PaymentMeans = $paymentMeans;
        return $this;
    }
    /**
     * Get Createdate value
     * @return string
     */
    public function getCreatedate()
    {
        return $this->Createdate;
    }
    /**
     * Set Createdate value
     * @param string $createdate
     * @return \StructType\InvoiceInfoResult
     */
    public function setCreatedate($createdate = null)
    {
        // validation for constraint: string
        if (!is_null($createdate) && !is_string($createdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdate, true), gettype($createdate)), __LINE__);
        }
        $this->Createdate = $createdate;
        return $this;
    }
    /**
     * Get Direction value
     * @return string
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @uses \EnumType\Direction::valueIsValid()
     * @uses \EnumType\Direction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \StructType\InvoiceInfoResult
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Direction::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Direction', is_array($direction) ? implode(', ', $direction) : var_export($direction, true), implode(', ', \EnumType\Direction::getValidValues())), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get Options value
     * @return \ArrayType\ArrayOfInvoiceOption|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param \ArrayType\ArrayOfInvoiceOption $options
     * @return \StructType\InvoiceInfoResult
     */
    public function setOptions(\ArrayType\ArrayOfInvoiceOption $options = null)
    {
        $this->Options = $options;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\InvoiceInfoResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\InvoiceInfoResult
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return \StructType\InvoiceInfoResult
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get ReturnValue value
     * @return string|null
     */
    public function getReturnValue()
    {
        return $this->ReturnValue;
    }
    /**
     * Set ReturnValue value
     * @param string $returnValue
     * @return \StructType\InvoiceInfoResult
     */
    public function setReturnValue($returnValue = null)
    {
        // validation for constraint: string
        if (!is_null($returnValue) && !is_string($returnValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnValue, true), gettype($returnValue)), __LINE__);
        }
        $this->ReturnValue = $returnValue;
        return $this;
    }
    /**
     * Get StatusDescription value
     * @return string|null
     */
    public function getStatusDescription()
    {
        return $this->StatusDescription;
    }
    /**
     * Set StatusDescription value
     * @param string $statusDescription
     * @return \StructType\InvoiceInfoResult
     */
    public function setStatusDescription($statusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($statusDescription) && !is_string($statusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDescription, true), gettype($statusDescription)), __LINE__);
        }
        $this->StatusDescription = $statusDescription;
        return $this;
    }
    /**
     * Get Invoicetypecode value
     * @return string|null
     */
    public function getInvoicetypecode()
    {
        return $this->Invoicetypecode;
    }
    /**
     * Set Invoicetypecode value
     * @param string $invoicetypecode
     * @return \StructType\InvoiceInfoResult
     */
    public function setInvoicetypecode($invoicetypecode = null)
    {
        // validation for constraint: string
        if (!is_null($invoicetypecode) && !is_string($invoicetypecode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicetypecode, true), gettype($invoicetypecode)), __LINE__);
        }
        $this->Invoicetypecode = $invoicetypecode;
        return $this;
    }
    /**
     * Get Sendertaxid value
     * @return string|null
     */
    public function getSendertaxid()
    {
        return $this->Sendertaxid;
    }
    /**
     * Set Sendertaxid value
     * @param string $sendertaxid
     * @return \StructType\InvoiceInfoResult
     */
    public function setSendertaxid($sendertaxid = null)
    {
        // validation for constraint: string
        if (!is_null($sendertaxid) && !is_string($sendertaxid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendertaxid, true), gettype($sendertaxid)), __LINE__);
        }
        $this->Sendertaxid = $sendertaxid;
        return $this;
    }
    /**
     * Get Receivertaxid value
     * @return string|null
     */
    public function getReceivertaxid()
    {
        return $this->Receivertaxid;
    }
    /**
     * Set Receivertaxid value
     * @param string $receivertaxid
     * @return \StructType\InvoiceInfoResult
     */
    public function setReceivertaxid($receivertaxid = null)
    {
        // validation for constraint: string
        if (!is_null($receivertaxid) && !is_string($receivertaxid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receivertaxid, true), gettype($receivertaxid)), __LINE__);
        }
        $this->Receivertaxid = $receivertaxid;
        return $this;
    }
    /**
     * Get Profileid value
     * @return string|null
     */
    public function getProfileid()
    {
        return $this->Profileid;
    }
    /**
     * Set Profileid value
     * @param string $profileid
     * @return \StructType\InvoiceInfoResult
     */
    public function setProfileid($profileid = null)
    {
        // validation for constraint: string
        if (!is_null($profileid) && !is_string($profileid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileid, true), gettype($profileid)), __LINE__);
        }
        $this->Profileid = $profileid;
        return $this;
    }
    /**
     * Get Payableamount value
     * @return string|null
     */
    public function getPayableamount()
    {
        return $this->Payableamount;
    }
    /**
     * Set Payableamount value
     * @param string $payableamount
     * @return \StructType\InvoiceInfoResult
     */
    public function setPayableamount($payableamount = null)
    {
        // validation for constraint: string
        if (!is_null($payableamount) && !is_string($payableamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payableamount, true), gettype($payableamount)), __LINE__);
        }
        $this->Payableamount = $payableamount;
        return $this;
    }
    /**
     * Get Partyname value
     * @return string|null
     */
    public function getPartyname()
    {
        return $this->Partyname;
    }
    /**
     * Set Partyname value
     * @param string $partyname
     * @return \StructType\InvoiceInfoResult
     */
    public function setPartyname($partyname = null)
    {
        // validation for constraint: string
        if (!is_null($partyname) && !is_string($partyname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyname, true), gettype($partyname)), __LINE__);
        }
        $this->Partyname = $partyname;
        return $this;
    }
    /**
     * Get ReceiverPostBoxName value
     * @return string|null
     */
    public function getReceiverPostBoxName()
    {
        return $this->ReceiverPostBoxName;
    }
    /**
     * Set ReceiverPostBoxName value
     * @param string $receiverPostBoxName
     * @return \StructType\InvoiceInfoResult
     */
    public function setReceiverPostBoxName($receiverPostBoxName = null)
    {
        // validation for constraint: string
        if (!is_null($receiverPostBoxName) && !is_string($receiverPostBoxName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverPostBoxName, true), gettype($receiverPostBoxName)), __LINE__);
        }
        $this->ReceiverPostBoxName = $receiverPostBoxName;
        return $this;
    }
    /**
     * Get SenderPostBoxName value
     * @return string|null
     */
    public function getSenderPostBoxName()
    {
        return $this->SenderPostBoxName;
    }
    /**
     * Set SenderPostBoxName value
     * @param string $senderPostBoxName
     * @return \StructType\InvoiceInfoResult
     */
    public function setSenderPostBoxName($senderPostBoxName = null)
    {
        // validation for constraint: string
        if (!is_null($senderPostBoxName) && !is_string($senderPostBoxName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderPostBoxName, true), gettype($senderPostBoxName)), __LINE__);
        }
        $this->SenderPostBoxName = $senderPostBoxName;
        return $this;
    }
    /**
     * Get DocumentCurrency value
     * @return string|null
     */
    public function getDocumentCurrency()
    {
        return $this->DocumentCurrency;
    }
    /**
     * Set DocumentCurrency value
     * @param string $documentCurrency
     * @return \StructType\InvoiceInfoResult
     */
    public function setDocumentCurrency($documentCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($documentCurrency) && !is_string($documentCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentCurrency, true), gettype($documentCurrency)), __LINE__);
        }
        $this->DocumentCurrency = $documentCurrency;
        return $this;
    }
    /**
     * Get OrderReferenceNo value
     * @return string|null
     */
    public function getOrderReferenceNo()
    {
        return $this->OrderReferenceNo;
    }
    /**
     * Set OrderReferenceNo value
     * @param string $orderReferenceNo
     * @return \StructType\InvoiceInfoResult
     */
    public function setOrderReferenceNo($orderReferenceNo = null)
    {
        // validation for constraint: string
        if (!is_null($orderReferenceNo) && !is_string($orderReferenceNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderReferenceNo, true), gettype($orderReferenceNo)), __LINE__);
        }
        $this->OrderReferenceNo = $orderReferenceNo;
        return $this;
    }
    /**
     * Get ReferenceNo value
     * @return string|null
     */
    public function getReferenceNo()
    {
        return $this->ReferenceNo;
    }
    /**
     * Set ReferenceNo value
     * @param string $referenceNo
     * @return \StructType\InvoiceInfoResult
     */
    public function setReferenceNo($referenceNo = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNo) && !is_string($referenceNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNo, true), gettype($referenceNo)), __LINE__);
        }
        $this->ReferenceNo = $referenceNo;
        return $this;
    }
    /**
     * Get BranchNo value
     * @return string|null
     */
    public function getBranchNo()
    {
        return $this->BranchNo;
    }
    /**
     * Set BranchNo value
     * @param string $branchNo
     * @return \StructType\InvoiceInfoResult
     */
    public function setBranchNo($branchNo = null)
    {
        // validation for constraint: string
        if (!is_null($branchNo) && !is_string($branchNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchNo, true), gettype($branchNo)), __LINE__);
        }
        $this->BranchNo = $branchNo;
        return $this;
    }
    /**
     * Get BranchName value
     * @return string|null
     */
    public function getBranchName()
    {
        return $this->BranchName;
    }
    /**
     * Set BranchName value
     * @param string $branchName
     * @return \StructType\InvoiceInfoResult
     */
    public function setBranchName($branchName = null)
    {
        // validation for constraint: string
        if (!is_null($branchName) && !is_string($branchName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchName, true), gettype($branchName)), __LINE__);
        }
        $this->BranchName = $branchName;
        return $this;
    }
}
