<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetReconciliationEArchiveByDateExtended StructType
 * @subpackage Structs
 */
class GetReconciliationEArchiveByDateExtended extends AbstractStructBase
{
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The CorporateCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorporateCode;
    /**
     * The eArchiveInvoices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEArchiveReconciliationInvoices
     */
    public $eArchiveInvoices;
    /**
     * The StoreNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StoreNumber;
    /**
     * The WorkStation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkStation;
    /**
     * Constructor method for GetReconciliationEArchiveByDateExtended
     * @uses GetReconciliationEArchiveByDateExtended::setStartDate()
     * @uses GetReconciliationEArchiveByDateExtended::setEndDate()
     * @uses GetReconciliationEArchiveByDateExtended::setTicket()
     * @uses GetReconciliationEArchiveByDateExtended::setCorporateCode()
     * @uses GetReconciliationEArchiveByDateExtended::setEArchiveInvoices()
     * @uses GetReconciliationEArchiveByDateExtended::setStoreNumber()
     * @uses GetReconciliationEArchiveByDateExtended::setWorkStation()
     * @param string $startDate
     * @param string $endDate
     * @param string $ticket
     * @param string $corporateCode
     * @param \ArrayType\ArrayOfEArchiveReconciliationInvoices $eArchiveInvoices
     * @param string $storeNumber
     * @param string $workStation
     */
    public function __construct($startDate = null, $endDate = null, $ticket = null, $corporateCode = null, \ArrayType\ArrayOfEArchiveReconciliationInvoices $eArchiveInvoices = null, $storeNumber = null, $workStation = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setTicket($ticket)
            ->setCorporateCode($corporateCode)
            ->setEArchiveInvoices($eArchiveInvoices)
            ->setStoreNumber($storeNumber)
            ->setWorkStation($workStation);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\GetReconciliationEArchiveByDateExtended
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\GetReconciliationEArchiveByDateExtended
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\GetReconciliationEArchiveByDateExtended
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get CorporateCode value
     * @return string|null
     */
    public function getCorporateCode()
    {
        return $this->CorporateCode;
    }
    /**
     * Set CorporateCode value
     * @param string $corporateCode
     * @return \StructType\GetReconciliationEArchiveByDateExtended
     */
    public function setCorporateCode($corporateCode = null)
    {
        // validation for constraint: string
        if (!is_null($corporateCode) && !is_string($corporateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporateCode, true), gettype($corporateCode)), __LINE__);
        }
        $this->CorporateCode = $corporateCode;
        return $this;
    }
    /**
     * Get eArchiveInvoices value
     * @return \ArrayType\ArrayOfEArchiveReconciliationInvoices|null
     */
    public function getEArchiveInvoices()
    {
        return $this->eArchiveInvoices;
    }
    /**
     * Set eArchiveInvoices value
     * @param \ArrayType\ArrayOfEArchiveReconciliationInvoices $eArchiveInvoices
     * @return \StructType\GetReconciliationEArchiveByDateExtended
     */
    public function setEArchiveInvoices(\ArrayType\ArrayOfEArchiveReconciliationInvoices $eArchiveInvoices = null)
    {
        $this->eArchiveInvoices = $eArchiveInvoices;
        return $this;
    }
    /**
     * Get StoreNumber value
     * @return string|null
     */
    public function getStoreNumber()
    {
        return $this->StoreNumber;
    }
    /**
     * Set StoreNumber value
     * @param string $storeNumber
     * @return \StructType\GetReconciliationEArchiveByDateExtended
     */
    public function setStoreNumber($storeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($storeNumber) && !is_string($storeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeNumber, true), gettype($storeNumber)), __LINE__);
        }
        $this->StoreNumber = $storeNumber;
        return $this;
    }
    /**
     * Get WorkStation value
     * @return string|null
     */
    public function getWorkStation()
    {
        return $this->WorkStation;
    }
    /**
     * Set WorkStation value
     * @param string $workStation
     * @return \StructType\GetReconciliationEArchiveByDateExtended
     */
    public function setWorkStation($workStation = null)
    {
        // validation for constraint: string
        if (!is_null($workStation) && !is_string($workStation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workStation, true), gettype($workStation)), __LINE__);
        }
        $this->WorkStation = $workStation;
        return $this;
    }
}
