<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInvoiceTemplate StructType
 * @subpackage Structs
 */
class GetInvoiceTemplate extends AbstractStructBase
{
    /**
     * The InvoiceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceType;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The TemplateCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateCode;
    /**
     * Constructor method for GetInvoiceTemplate
     * @uses GetInvoiceTemplate::setInvoiceType()
     * @uses GetInvoiceTemplate::setTicket()
     * @uses GetInvoiceTemplate::setTemplateCode()
     * @param int $invoiceType
     * @param string $ticket
     * @param string $templateCode
     */
    public function __construct($invoiceType = null, $ticket = null, $templateCode = null)
    {
        $this
            ->setInvoiceType($invoiceType)
            ->setTicket($ticket)
            ->setTemplateCode($templateCode);
    }
    /**
     * Get InvoiceType value
     * @return int
     */
    public function getInvoiceType()
    {
        return $this->InvoiceType;
    }
    /**
     * Set InvoiceType value
     * @param int $invoiceType
     * @return \StructType\GetInvoiceTemplate
     */
    public function setInvoiceType($invoiceType = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceType) && !(is_int($invoiceType) || ctype_digit($invoiceType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceType, true), gettype($invoiceType)), __LINE__);
        }
        $this->InvoiceType = $invoiceType;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\GetInvoiceTemplate
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get TemplateCode value
     * @return string|null
     */
    public function getTemplateCode()
    {
        return $this->TemplateCode;
    }
    /**
     * Set TemplateCode value
     * @param string $templateCode
     * @return \StructType\GetInvoiceTemplate
     */
    public function setTemplateCode($templateCode = null)
    {
        // validation for constraint: string
        if (!is_null($templateCode) && !is_string($templateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateCode, true), gettype($templateCode)), __LINE__);
        }
        $this->TemplateCode = $templateCode;
        return $this;
    }
}
