<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetIncomingInvoiceBranchInfo StructType
 * @subpackage Structs
 */
class GetIncomingInvoiceBranchInfo extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The Invoices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvoiceInfoQuery
     */
    public $Invoices;
    /**
     * Constructor method for GetIncomingInvoiceBranchInfo
     * @uses GetIncomingInvoiceBranchInfo::setTicket()
     * @uses GetIncomingInvoiceBranchInfo::setInvoices()
     * @param string $ticket
     * @param \ArrayType\ArrayOfInvoiceInfoQuery $invoices
     */
    public function __construct($ticket = null, \ArrayType\ArrayOfInvoiceInfoQuery $invoices = null)
    {
        $this
            ->setTicket($ticket)
            ->setInvoices($invoices);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\GetIncomingInvoiceBranchInfo
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get Invoices value
     * @return \ArrayType\ArrayOfInvoiceInfoQuery|null
     */
    public function getInvoices()
    {
        return $this->Invoices;
    }
    /**
     * Set Invoices value
     * @param \ArrayType\ArrayOfInvoiceInfoQuery $invoices
     * @return \StructType\GetIncomingInvoiceBranchInfo
     */
    public function setInvoices(\ArrayType\ArrayOfInvoiceInfoQuery $invoices = null)
    {
        $this->Invoices = $invoices;
        return $this;
    }
}
