<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailableInvoicesPW StructType
 * @subpackage Structs
 */
class GetAvailableInvoicesPW extends AbstractStructBase
{
    /**
     * The direction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $direction;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The ErpCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErpCode;
    /**
     * The LoginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginName;
    /**
     * Constructor method for GetAvailableInvoicesPW
     * @uses GetAvailableInvoicesPW::setDirection()
     * @uses GetAvailableInvoicesPW::setTicket()
     * @uses GetAvailableInvoicesPW::setErpCode()
     * @uses GetAvailableInvoicesPW::setLoginName()
     * @param string $direction
     * @param string $ticket
     * @param string $erpCode
     * @param string $loginName
     */
    public function __construct($direction = null, $ticket = null, $erpCode = null, $loginName = null)
    {
        $this
            ->setDirection($direction)
            ->setTicket($ticket)
            ->setErpCode($erpCode)
            ->setLoginName($loginName);
    }
    /**
     * Get direction value
     * @return string
     */
    public function getDirection()
    {
        return $this->direction;
    }
    /**
     * Set direction value
     * @uses \EnumType\Direction::valueIsValid()
     * @uses \EnumType\Direction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \StructType\GetAvailableInvoicesPW
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Direction::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Direction', is_array($direction) ? implode(', ', $direction) : var_export($direction, true), implode(', ', \EnumType\Direction::getValidValues())), __LINE__);
        }
        $this->direction = $direction;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\GetAvailableInvoicesPW
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get ErpCode value
     * @return string|null
     */
    public function getErpCode()
    {
        return $this->ErpCode;
    }
    /**
     * Set ErpCode value
     * @param string $erpCode
     * @return \StructType\GetAvailableInvoicesPW
     */
    public function setErpCode($erpCode = null)
    {
        // validation for constraint: string
        if (!is_null($erpCode) && !is_string($erpCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erpCode, true), gettype($erpCode)), __LINE__);
        }
        $this->ErpCode = $erpCode;
        return $this;
    }
    /**
     * Get LoginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->LoginName;
    }
    /**
     * Set LoginName value
     * @param string $loginName
     * @return \StructType\GetAvailableInvoicesPW
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        $this->LoginName = $loginName;
        return $this;
    }
}
