<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CorporateTemplateResult StructType
 * @subpackage Structs
 */
class CorporateTemplateResult extends AbstractStructBase
{
    /**
     * The ServiceResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceResult;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The ServiceResultDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceResultDescription;
    /**
     * The TemplateCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateCode;
    /**
     * The InvoiceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceType;
    /**
     * The TemplatePrefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplatePrefix;
    /**
     * The Template
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Template;
    /**
     * Constructor method for CorporateTemplateResult
     * @uses CorporateTemplateResult::setServiceResult()
     * @uses CorporateTemplateResult::setErrorCode()
     * @uses CorporateTemplateResult::setServiceResultDescription()
     * @uses CorporateTemplateResult::setTemplateCode()
     * @uses CorporateTemplateResult::setInvoiceType()
     * @uses CorporateTemplateResult::setTemplatePrefix()
     * @uses CorporateTemplateResult::setTemplate()
     * @param string $serviceResult
     * @param int $errorCode
     * @param string $serviceResultDescription
     * @param string $templateCode
     * @param string $invoiceType
     * @param string $templatePrefix
     * @param string $template
     */
    public function __construct($serviceResult = null, $errorCode = null, $serviceResultDescription = null, $templateCode = null, $invoiceType = null, $templatePrefix = null, $template = null)
    {
        $this
            ->setServiceResult($serviceResult)
            ->setErrorCode($errorCode)
            ->setServiceResultDescription($serviceResultDescription)
            ->setTemplateCode($templateCode)
            ->setInvoiceType($invoiceType)
            ->setTemplatePrefix($templatePrefix)
            ->setTemplate($template);
    }
    /**
     * Get ServiceResult value
     * @return string
     */
    public function getServiceResult()
    {
        return $this->ServiceResult;
    }
    /**
     * Set ServiceResult value
     * @uses \EnumType\Result::valueIsValid()
     * @uses \EnumType\Result::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceResult
     * @return \StructType\CorporateTemplateResult
     */
    public function setServiceResult($serviceResult = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Result::valueIsValid($serviceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Result', is_array($serviceResult) ? implode(', ', $serviceResult) : var_export($serviceResult, true), implode(', ', \EnumType\Result::getValidValues())), __LINE__);
        }
        $this->ServiceResult = $serviceResult;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\CorporateTemplateResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ServiceResultDescription value
     * @return string|null
     */
    public function getServiceResultDescription()
    {
        return $this->ServiceResultDescription;
    }
    /**
     * Set ServiceResultDescription value
     * @param string $serviceResultDescription
     * @return \StructType\CorporateTemplateResult
     */
    public function setServiceResultDescription($serviceResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($serviceResultDescription) && !is_string($serviceResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceResultDescription, true), gettype($serviceResultDescription)), __LINE__);
        }
        $this->ServiceResultDescription = $serviceResultDescription;
        return $this;
    }
    /**
     * Get TemplateCode value
     * @return string|null
     */
    public function getTemplateCode()
    {
        return $this->TemplateCode;
    }
    /**
     * Set TemplateCode value
     * @param string $templateCode
     * @return \StructType\CorporateTemplateResult
     */
    public function setTemplateCode($templateCode = null)
    {
        // validation for constraint: string
        if (!is_null($templateCode) && !is_string($templateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateCode, true), gettype($templateCode)), __LINE__);
        }
        $this->TemplateCode = $templateCode;
        return $this;
    }
    /**
     * Get InvoiceType value
     * @return string|null
     */
    public function getInvoiceType()
    {
        return $this->InvoiceType;
    }
    /**
     * Set InvoiceType value
     * @param string $invoiceType
     * @return \StructType\CorporateTemplateResult
     */
    public function setInvoiceType($invoiceType = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceType) && !is_string($invoiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceType, true), gettype($invoiceType)), __LINE__);
        }
        $this->InvoiceType = $invoiceType;
        return $this;
    }
    /**
     * Get TemplatePrefix value
     * @return string|null
     */
    public function getTemplatePrefix()
    {
        return $this->TemplatePrefix;
    }
    /**
     * Set TemplatePrefix value
     * @param string $templatePrefix
     * @return \StructType\CorporateTemplateResult
     */
    public function setTemplatePrefix($templatePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($templatePrefix) && !is_string($templatePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templatePrefix, true), gettype($templatePrefix)), __LINE__);
        }
        $this->TemplatePrefix = $templatePrefix;
        return $this;
    }
    /**
     * Get Template value
     * @return string|null
     */
    public function getTemplate()
    {
        return $this->Template;
    }
    /**
     * Set Template value
     * @param string $template
     * @return \StructType\CorporateTemplateResult
     */
    public function setTemplate($template = null)
    {
        // validation for constraint: string
        if (!is_null($template) && !is_string($template)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($template, true), gettype($template)), __LINE__);
        }
        $this->Template = $template;
        return $this;
    }
}
