<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckTaxIdListFromExcelFile StructType
 * @subpackage Structs
 */
class CheckTaxIdListFromExcelFile extends AbstractStructBase
{
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket;
    /**
     * The FileData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileData;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * Constructor method for CheckTaxIdListFromExcelFile
     * @uses CheckTaxIdListFromExcelFile::setTicket()
     * @uses CheckTaxIdListFromExcelFile::setFileData()
     * @uses CheckTaxIdListFromExcelFile::setFileName()
     * @param string $ticket
     * @param string $fileData
     * @param string $fileName
     */
    public function __construct($ticket = null, $fileData = null, $fileName = null)
    {
        $this
            ->setTicket($ticket)
            ->setFileData($fileData)
            ->setFileName($fileName);
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param string $ticket
     * @return \StructType\CheckTaxIdListFromExcelFile
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get FileData value
     * @return string|null
     */
    public function getFileData()
    {
        return $this->FileData;
    }
    /**
     * Set FileData value
     * @param string $fileData
     * @return \StructType\CheckTaxIdListFromExcelFile
     */
    public function setFileData($fileData = null)
    {
        // validation for constraint: string
        if (!is_null($fileData) && !is_string($fileData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileData, true), gettype($fileData)), __LINE__);
        }
        $this->FileData = $fileData;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\CheckTaxIdListFromExcelFile
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
}
