<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Using ServiceType
 * @subpackage Services
 */
class Using extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UsingCountsForPartner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UsingCountsForPartner $parameters
     * @return \StructType\UsingCountsForPartnerResponse|bool
     */
    public function UsingCountsForPartner(\StructType\UsingCountsForPartner $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UsingCountsForPartner($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UsingCountsForPartnerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
